/*
*  Common
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact: 
* BonYong Lee <bonyong.lee@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.common.util;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.fail;

import org.junit.Test;

/**
 * AssertTest
 *
 * Test case for {@link Assert}
 * 
 * @author BonYong Lee{@literal <bonyong.lee@samsung.com>} (S-Core)
 * 
 * @see Assert
 */
public class
AssertTest
{
	/**
	 * Test {@link Assert#fail(String)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see {@link Assert#fail(String)}
	 */
	@Test
	public
	void
	test_fail()
	throws Exception
	{
		try
		{
			Assert.fail( "Hello" );
			fail();
		}
		catch ( final IllegalArgumentException e )
		{
			assertEquals( "Hello", e.getMessage() );
		}
	}

	/**
	 * Test {@link Assert#isTrue(boolean)} and
	 * {@link Assert#isTrue(boolean, String)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see {@link Assert#isTrue(boolean)}
	 * @see {@link Assert#isTrue(boolean, String)}
	 */
	@Test
	public
	void 
	test_assertTrue()
	throws Exception
	{
		int a = 5;
		int b = 2;
		Assert.isTrue( 3 == a-b, "Good case" );
		
		Assert.isTrue( 3 == a-b );
		Assert.isTrue( "abc".equals( "abc" ) );
		try
		{
			Assert.isTrue( 3==4 );
			fail();
		}
		catch ( final IllegalArgumentException e )
		{
		}
		
	}

	/**
	 * Test {@link Assert#assertFalse(boolean)} and
	 * {@link Assert#assertFalse(boolean, String)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see {@link Assert#assertFalse(boolean)}
	 * @see {@link Assert#assertFalse(boolean, String)}
	 */
	@Test
	public void
	test_assertFalse()
	throws Exception
	{
		Assert.isFalse( 3 == 4, "Assertion passed" );
		Assert.isFalse( 3 == 4 );
	}
	
	/**
	 * Test {@link Assert#isNull(Object)} and
	 * {@link Assert#isNull(Object, String)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see {@link Assert#isNull(Object)}
	 * @see {@link Assert#isNull(Object, String)}
	 */
	@Test
	public
	void
	test_assertNull()
	throws Exception
	{
		Assert.isNull( null );
		Assert.isNull( null, "Assertion passed" );
	}
	
	/**
	 * Test {@link Assert#notNull(boolean)} and
	 * {@link Assert#notNull(boolean, String)}
	 * 
	 * @throws Exception in case of failure in test
	 * 
	 * @see {@link Assert#notNull(boolean)}
	 * @see {@link Assert#notNull(boolean, String)}
	 */
	@Test
	public
	void
	test_notNull()
	throws Exception
	{
		
		Assert.notNull( new Object() );
		Assert.notNull( "Hello", "Assertion passed" );
		
	}
	
}
