/*
*  Common
*
* Copyright (c) 2000 - 2011 Samsung Electronics Co., Ltd. All rights reserved.
*
* Contact: 
* GyeongSeok Seo <gyeongseok.seo@samsung.com>
* 
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*
* http://www.apache.org/licenses/LICENSE-2.0
*
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*
* Contributors:
* - S-Core Co., Ltd
*
*/
package org.tizen.common.util;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertNull;
import static org.powermock.api.mockito.PowerMockito.mock;
import static org.powermock.api.mockito.PowerMockito.mockStatic;
import static org.powermock.api.mockito.PowerMockito.when;
import static org.powermock.api.mockito.PowerMockito.whenNew;

import java.io.ByteArrayInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

import org.junit.Test;
import org.junit.runner.RunWith;
import org.powermock.core.classloader.annotations.PrepareForTest;
import org.powermock.modules.junit4.PowerMockRunner;

/**
 * ZipUtilTest
 * 
 * Test case for {@link ZipUtil}
 * 
 * @author GyeongSeok Seo{@literal <gyeongseok.seo@samsung.com>} (S-Core)
 * 
 * @see ZipUtil
 */
@RunWith( PowerMockRunner.class )
@PrepareForTest( { ZipUtil.class, FilenameUtil.class } )
public class
ZipUtilTest
{

    /**
     * Test {@link ZipUtil#getContent(String, String)}
     * 
     * @throws Exception in case of failure in test
     *
     * @see {@link ZipUtil#getContent(String, String)}
     */
    @Test
    public void
    test_getContent()
    throws Exception
    {
        final ZipFile zipFile = mock( ZipFile.class );
        final ZipEntry zipEntry = mock( ZipEntry.class );
        
        mockStatic( FilenameUtil.class );
        when( FilenameUtil.getCanonicalPath( "test/test_files/resource/test.zip" ) ).thenReturn( "/mock/test/test_files/resource/test.zip" );
        whenNew( ZipFile.class ).withArguments( "/mock/test/test_files/resource/test.zip" ).thenReturn( zipFile );
        when( zipFile.getEntry( "config.xml" ) ).thenReturn( zipEntry );
        when( zipFile.getInputStream( zipEntry ) ).thenReturn( new ByteArrayInputStream( "Hello".getBytes() ) );
        assertNull( ZipUtil.getContent( null, null ) );
        assertNull( ZipUtil.getContent( null, "text.text" ) );
        assertNull( ZipUtil.getContent( "test/test_files/resource/test.zip", null ) );
        assertNull( ZipUtil.getContent( "test/test_files/resource/test", "config.text" ) );
        assertNull( ZipUtil.getContent( "test/test_files/resource/test.zip", "config.t" ) );
        assertNull( ZipUtil.getContent( "test/test_files/resource/test.zip", "config.text" ) );
        assertNotNull( ZipUtil.getContent( "test/test_files/resource/test.zip", "config.xml" ) );
    }
}
