/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.preferenceWindow.widgets;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.preferenceWindow.PreferenceWindow;
import org.mihalis.opal.preferenceWindow.widgets.PWWidget;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class PWColorChooser
extends PWWidget {
    private Color color;

    public PWColorChooser(String label, String propertyKey) {
        super(label, propertyKey, label == null ? 1 : 2, false);
    }

    @Override
    public Control build(Composite parent) {
        RGB rgb = (RGB)PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        this.color = rgb == null ? Display.getDefault().getSystemColor(1) : new Color((Device)Display.getDefault(), rgb);
        this.buildLabel(parent, 2);
        final Button button = new Button(parent, 8);
        this.addControl((Control)button);
        button.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                PWColorChooser.this.drawButton(button);
            }
        });
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                ColorDialog dialog = new ColorDialog(button.getShell());
                RGB result = dialog.open();
                if (result != null) {
                    SWTGraphicUtil.dispose((Resource)PWColorChooser.this.color);
                    PWColorChooser.this.color = new Color((Device)button.getDisplay(), result);
                    PWColorChooser.this.drawButton(button);
                    PreferenceWindow.getInstance().setValue(PWColorChooser.this.getPropertyKey(), result);
                }
            }
        });
        button.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                SWTGraphicUtil.dispose((Resource)PWColorChooser.this.color);
            }
        });
        return button;
    }

    protected void drawButton(Button button) {
        int height = (int)button.getFont().getFontData()[0].height;
        int width = button.getBounds().width - 16;
        Image newImage = new Image((Device)button.getDisplay(), Math.max(1, width), Math.max(1, height));
        GC gc = new GC((Drawable)newImage);
        gc.setBackground(this.color);
        gc.fillRectangle(0, 0, width, height);
        gc.setForeground(button.getDisplay().getSystemColor(2));
        gc.drawRectangle(0, 0, width - 1, height - 1);
        gc.dispose();
        button.setImage(newImage);
    }

    @Override
    public void check() {
        Object value = PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        if (value == null) {
            PreferenceWindow.getInstance().setValue(this.getPropertyKey(), null);
        } else if (!(value instanceof RGB)) {
            throw new UnsupportedOperationException("The property '" + this.getPropertyKey() + "' has to be a RGB because it is associated to a color chooser");
        }
    }
}

