/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.preferenceWindow.widgets;

import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.mihalis.opal.preferenceWindow.PreferenceWindow;
import org.mihalis.opal.preferenceWindow.widgets.PWChooser;
import org.mihalis.opal.utils.ResourceManager;

public class PWFontChooser
extends PWChooser {
    private FontData fontData;

    public PWFontChooser(String label, String propertyKey) {
        super(label, propertyKey);
    }

    @Override
    public void check() {
        Object value = PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        if (value == null) {
            PreferenceWindow.getInstance().setValue(this.getPropertyKey(), null);
        } else if (!(value instanceof FontData)) {
            throw new UnsupportedOperationException("The property '" + this.getPropertyKey() + "' has to be a FontData because it is associated to a font chooser");
        }
    }

    @Override
    protected void setButtonAction(final Text text, Button button) {
        this.fontData = (FontData)PreferenceWindow.getInstance().getValueFor(this.getPropertyKey());
        button.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                FontDialog dialog = new FontDialog(text.getShell());
                FontData result = dialog.open();
                if (result != null && result.getName() != null && !"".equals(result.getName().trim())) {
                    PWFontChooser.this.fontData = result;
                    PreferenceWindow.getInstance().setValue(PWFontChooser.this.getPropertyKey(), result);
                    text.setText(PWFontChooser.this.buildFontInformation());
                }
            }
        });
    }

    protected String buildFontInformation() {
        StringBuilder sb = new StringBuilder();
        if (this.fontData != null) {
            sb.append(this.fontData.getName()).append(",").append(this.fontData.getHeight()).append(" pt");
            if ((this.fontData.getStyle() & 1) == 1) {
                sb.append(", ").append(ResourceManager.getLabel("bold"));
            }
            if ((this.fontData.getStyle() & 2) == 2) {
                sb.append(", ").append(ResourceManager.getLabel("italic"));
            }
        }
        return sb.toString();
    }
}

