/*
 * Decompiled with CFR 0.152.
 */
package zipeditor;

import java.lang.reflect.Array;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import zipeditor.ZipEditorPlugin;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    public void initializeDefaultPreferences() {
        IPreferenceStore store = ZipEditorPlugin.getDefault().getPreferenceStore();
        store.setDefault("outlineVIEW_MODE", 2);
        store.setDefault("outlineSORT_ENABLED", true);
        store.setDefault("commonNavigatorVIEW_MODE", 2);
        store.setDefault("commonNavigatorSORT_ENABLED", true);
        store.setDefault("editorVIEW_MODE", 8);
        store.setDefault("editorSORT_ENABLED", true);
        store.setDefault("SORT_BY", 1);
        store.setDefault("SORT_DIRECTION", 128);
        store.setDefault("VISIBLE_COLUMNS", PreferenceInitializer.join(new Object[]{new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(9)}, ","));
    }

    public static final String join(Object array, String separator) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int n = Array.getLength(array);
        while (i < n) {
            Object object;
            if (sb.length() > 0) {
                sb.append(separator);
            }
            if ((object = Array.get(array, i)) != null) {
                sb.append(object);
            }
            ++i;
        }
        return sb.toString();
    }

    public static final Object split(String string, String separator, Class elementType) {
        StringTokenizer st = new StringTokenizer(string, separator);
        int size = st.countTokens();
        Object result = Array.newInstance(elementType, size);
        int i = 0;
        while (i < size) {
            try {
                Array.set(result, i, PreferenceInitializer.valueFromString(st.nextToken(), elementType));
            }
            catch (Exception e) {
                ZipEditorPlugin.log(e);
            }
            ++i;
        }
        return result;
    }

    private static Object valueFromString(String string, Class type) throws Exception {
        if (type == Integer.TYPE) {
            type = Integer.class;
        } else if (type == Short.TYPE) {
            type = Short.class;
        } else if (type == Long.TYPE) {
            type = Long.class;
        } else if (type == Double.TYPE) {
            type = Double.class;
        } else if (type == Float.TYPE) {
            type = Float.class;
        } else if (type == Character.TYPE) {
            type = Character.class;
        } else if (type == Boolean.TYPE) {
            type = Boolean.class;
        }
        return type.getConstructor(String.class).newInstance(string);
    }
}

