/*
 * Decompiled with CFR 0.152.
 */
package zipeditor;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;
import zipeditor.Messages;
import zipeditor.Utils;
import zipeditor.ZipContentProvider;
import zipeditor.ZipEditor;
import zipeditor.ZipEditorDragAdapter;
import zipeditor.ZipEditorDropAdapter;
import zipeditor.ZipEditorPlugin;
import zipeditor.ZipLabelProvider;
import zipeditor.ZipSorter;
import zipeditor.actions.AddAction;
import zipeditor.actions.CollapseAllAction;
import zipeditor.actions.DeleteAction;
import zipeditor.actions.ExtractAction;
import zipeditor.actions.MultiPropertyDialogAction;
import zipeditor.actions.NewFolderAction;
import zipeditor.actions.RenameNodeAction;
import zipeditor.actions.SelectAllAction;
import zipeditor.actions.SortAction;
import zipeditor.actions.ViewerAction;
import zipeditor.model.Node;

public class ZipOutlinePage
extends ContentOutlinePage {
    private static final String PREFERENCE_LINKED = "outline_linked";
    private AddAction fAddAction;
    private ViewerAction fExtractAction;
    private ViewerAction fDeleteAction;
    private IAction fPropertiesAction;
    private SelectAllAction fSelectAllAction;
    private NewFolderAction fNewFolderAction;
    private RenameNodeAction fRenameNodeAction;

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.getTreeViewer().setContentProvider((IContentProvider)new ZipContentProvider(2));
        this.getTreeViewer().setLabelProvider((IBaseLabelProvider)new ZipLabelProvider());
        this.getTreeViewer().setSorter((ViewerSorter)new ZipSorter("outline"));
        this.getTreeViewer().setComparer((IElementComparer)new ZipEditor.NodeComparer());
        this.createActions();
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ZipOutlinePage.this.contextMenuAboutToShow((IContributionManager)manager);
            }
        });
        Menu contextMenu = manager.createContextMenu(this.getTreeViewer().getControl());
        this.getTreeViewer().getControl().setMenu(contextMenu);
        this.initDragAndDrop((StructuredViewer)this.getTreeViewer());
    }

    private void createActions() {
        this.fAddAction = new AddAction((StructuredViewer)this.getTreeViewer());
        this.fExtractAction = new ExtractAction((StructuredViewer)this.getTreeViewer());
        this.fDeleteAction = new DeleteAction((StructuredViewer)this.getTreeViewer());
        this.fSelectAllAction = new SelectAllAction((StructuredViewer)this.getTreeViewer());
        this.fPropertiesAction = new MultiPropertyDialogAction((IShellProvider)this.getSite(), (ISelectionProvider)this.getTreeViewer());
        this.fNewFolderAction = new NewFolderAction((StructuredViewer)this.getTreeViewer());
        this.fRenameNodeAction = new RenameNodeAction((StructuredViewer)this.getTreeViewer());
        this.updateActions();
    }

    private void updateActions() {
        boolean empty = this.getSelection().isEmpty();
        this.fDeleteAction.setEnabled(!empty);
        this.fPropertiesAction.setEnabled(!empty);
        this.getSite().getActionBars().setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.fDeleteAction);
        this.getSite().getActionBars().setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fSelectAllAction);
        this.getSite().getActionBars().setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), this.fPropertiesAction);
        this.getSite().getActionBars().setGlobalActionHandler(ActionFactory.RENAME.getId(), (IAction)this.fRenameNodeAction);
    }

    private void initDragAndDrop(StructuredViewer viewer) {
        int ops = 17;
        Transfer[] transfers = new Transfer[]{FileTransfer.getInstance()};
        viewer.addDragSupport(ops, transfers, (DragSourceListener)new ZipEditorDragAdapter((ISelectionProvider)this));
        viewer.addDropSupport(ops | 0x10, transfers, (DropTargetListener)new ZipEditorDropAdapter(viewer));
    }

    private void contextMenuAboutToShow(IContributionManager manager) {
        manager.add((IAction)this.fNewFolderAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fAddAction);
        manager.add((IAction)this.fExtractAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fDeleteAction);
        manager.add((IContributionItem)new Separator());
        manager.add(this.fPropertiesAction);
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        toolBarManager.add((IAction)new SortAction((StructuredViewer)this.getTreeViewer(), "outline"));
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)new CollapseAllAction((StructuredViewer)this.getTreeViewer()));
        toolBarManager.add((IAction)new LinkAction());
    }

    public void selectionChanged(SelectionChangedEvent event) {
        super.selectionChanged(event);
        this.updateActions();
    }

    public void setFocus() {
        super.setFocus();
        this.updateActions();
    }

    public void setInput(final Node node) {
        if (this.getTreeViewer() == null || this.getTreeViewer().getControl().isDisposed()) {
            return;
        }
        if (Utils.isUIThread()) {
            this.getTreeViewer().setInput((Object)node);
        } else {
            this.getTreeViewer().getControl().getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ZipOutlinePage.this.getTreeViewer().setInput((Object)node);
                }
            });
        }
    }

    public Object getInput() {
        return this.getTreeViewer().getInput();
    }

    public void refresh() {
        if (this.getTreeViewer() == null || this.getTreeViewer().getControl().isDisposed()) {
            return;
        }
        this.getTreeViewer().getControl().setRedraw(false);
        this.getTreeViewer().refresh();
        this.getTreeViewer().getControl().setRedraw(true);
    }

    public boolean isLinkingEnabled() {
        return ZipEditorPlugin.getDefault().getPreferenceStore().getBoolean(PREFERENCE_LINKED);
    }

    private class LinkAction
    extends Action {
        public LinkAction() {
            super(Messages.getString("ZipOutlinePage.0"));
            this.setToolTipText(Messages.getString("ZipOutlinePage.1"));
            this.setImageDescriptor(ZipEditorPlugin.getImageDescriptor("icons/elcl18/synced.png"));
            this.setDisabledImageDescriptor(ZipEditorPlugin.getImageDescriptor("icons/dlcl18/synced.png"));
            this.setChecked(ZipEditorPlugin.getDefault().getPreferenceStore().getBoolean(ZipOutlinePage.PREFERENCE_LINKED));
        }

        public void run() {
            Node[] nodes;
            boolean checked = this.isChecked();
            ZipEditorPlugin.getDefault().getPreferenceStore().setValue(ZipOutlinePage.PREFERENCE_LINKED, checked);
            IEditorPart editor = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            if (editor instanceof ZipEditor && (nodes = ((ZipEditor)editor).getSelectedNodes()).length == 1) {
                ZipOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)nodes[0]));
            }
        }
    }
}

