/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import zipeditor.Utils;
import zipeditor.actions.ActionMessages;
import zipeditor.actions.DeferredMenuManager;
import zipeditor.actions.FileOpener;
import zipeditor.actions.MostRecentlyUsedMenu;
import zipeditor.actions.OpenAction;
import zipeditor.actions.OpenWithMenu;
import zipeditor.model.FileAdapter;
import zipeditor.model.Node;

public class OpenActionGroup
extends ActionGroup {
    private OpenAction fOpenAction;
    private boolean fDisposed;
    private static final String GROUP_OPEN_RECENTLY_USED = "openRecentlyUsed";

    public OpenActionGroup(StructuredViewer viewer, boolean useOpenActionHandler) {
        this.fOpenAction = new OpenAction(viewer);
        if (useOpenActionHandler) {
            this.fOpenAction.setActionDefinitionId("org.eclipse.ui.navigator.Open");
        }
    }

    public void dispose() {
        this.fDisposed = true;
        super.dispose();
    }

    public void fillContextMenu(IMenuManager menu) {
        boolean onlyFilesSelected;
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        boolean bl = onlyFilesSelected = !selection.isEmpty() && Utils.allNodesAreFileNodes(selection);
        if (onlyFilesSelected) {
            Object element;
            if (menu.find("additions") != null) {
                menu.appendToGroup("additions", (IAction)this.fOpenAction);
                menu.appendToGroup("additions", (IContributionItem)new GroupMarker(GROUP_OPEN_RECENTLY_USED));
            } else {
                menu.add((IAction)this.fOpenAction);
                menu.add((IContributionItem)new GroupMarker(GROUP_OPEN_RECENTLY_USED));
            }
            if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof Node) {
                Node node = (Node)((Object)element);
                FileAdapter adapter = new FileAdapter(node);
                FileOpener fileOpener = new FileOpener(this.getActivePage(), node);
                this.fillOpenWithMenu(menu, adapter, fileOpener);
                this.fillMostRecentlyUsedItems(menu, adapter, fileOpener);
            }
        }
    }

    public void fillToolBarManager(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fOpenAction);
    }

    public void fillActionBars(IActionBars actionBars) {
        if (actionBars.getGlobalActionHandler(this.fOpenAction.getActionDefinitionId()) == null) {
            actionBars.setGlobalActionHandler(this.fOpenAction.getActionDefinitionId(), (IAction)this.fOpenAction);
        }
        this.updateActionBars();
    }

    private void fillOpenWithMenu(IMenuManager menu, final FileAdapter fileAdapter, final FileOpener fileOpener) {
        boolean isRunning = DeferredMenuManager.isRunning(fileAdapter, null);
        if (fileAdapter.isAdapted() && !isRunning) {
            MenuManager subMenu = new MenuManager(ActionMessages.getString("OpenActionGroup.0"), "org.eclipse.ui.OpenWithSubMenu");
            this.doAddToMenu((IMenuManager)subMenu, null, fileAdapter);
            if (menu.find("additions") != null) {
                menu.appendToGroup("additions", (IContributionItem)subMenu);
            } else {
                menu.add((IContributionItem)subMenu);
            }
        } else {
            DeferredMenuManager.MenuJob menuJob = new DeferredMenuManager.MenuJob(fileAdapter, null){

                @Override
                protected IStatus addToMenu(IProgressMonitor monitor, IMenuManager menu) {
                    if (!OpenActionGroup.this.fDisposed) {
                        OpenActionGroup.this.doAddToMenu(menu, fileOpener, fileAdapter);
                    }
                    return Status.OK_STATUS;
                }
            };
            DeferredMenuManager.addToMenu(menu, "additions", ActionMessages.getString("OpenActionGroup.0"), "org.eclipse.ui.OpenWithSubMenu", menuJob);
        }
    }

    private void doAddToMenu(IMenuManager subMenu, FileOpener fileOpener, FileAdapter adapter) {
        subMenu.add((IContributionItem)new OpenWithMenu(this.getActivePage(), fileOpener, adapter));
    }

    private void fillMostRecentlyUsedItems(IMenuManager menu, FileAdapter fileAdapter, FileOpener fileOpener) {
        if (menu.find("additions") != null) {
            menu.appendToGroup("additions", (IContributionItem)new MostRecentlyUsedMenu(fileOpener, fileAdapter));
        } else {
            menu.add((IContributionItem)new MostRecentlyUsedMenu(fileOpener, fileAdapter));
        }
    }

    private IWorkbenchPage getActivePage() {
        if (Utils.isUIThread()) {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        }
        final IWorkbenchPage[] result = new IWorkbenchPage[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                result[0] = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            }
        });
        return result[0];
    }
}

