/*
 * Decompiled with CFR 0.152.
 */
package zipeditor.actions;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolItem;
import zipeditor.PreferenceInitializer;
import zipeditor.ZipEditor;
import zipeditor.ZipEditorPlugin;
import zipeditor.actions.ActionMessages;
import zipeditor.actions.EditorAction;
import zipeditor.actions.ToggleStoreFoldersAction;
import zipeditor.actions.ToggleViewModeAction;
import zipeditor.model.NodeProperty;
import zipeditor.model.ZipNodeProperty;

public class PreferencesAction
extends EditorAction {
    private MenuManager fMenuManager;

    public PreferencesAction(ZipEditor editor) {
        super(ActionMessages.getString("PreferencesAction.0"), editor);
        this.setToolTipText(ActionMessages.getString("PreferencesAction.1"));
        this.setImageDescriptor(ZipEditorPlugin.getImageDescriptor("icons/arrow_down.gif"));
    }

    public void runWithEvent(Event event) {
        if (this.fMenuManager == null) {
            this.fMenuManager = new MenuManager();
            this.fillMenuManager(this.fMenuManager);
        }
        ToolItem item = (ToolItem)event.widget;
        Menu menu = this.fMenuManager.createContextMenu((Control)item.getParent());
        Rectangle bounds = item.getBounds();
        Point topLeft = new Point(bounds.x, bounds.y + bounds.height);
        topLeft = item.getParent().toDisplay(topLeft);
        menu.setLocation(topLeft.x, topLeft.y);
        menu.setVisible(true);
    }

    private void fillMenuManager(MenuManager manager) {
        MenuManager columns = new MenuManager(ActionMessages.getString("PreferencesAction.2"));
        manager.add((IContributionItem)columns);
        this.fillColumnsMenu(columns);
        MenuManager folders = new MenuManager(ActionMessages.getString("PreferencesAction.3"));
        manager.add((IContributionItem)folders);
        this.fillFoldersMenu(folders);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)new ToggleStoreFoldersAction(this.fEditor));
    }

    private void fillColumnsMenu(MenuManager manager) {
        manager.add((IAction)new ColumnAction(NodeProperty.PNAME));
        manager.add((IAction)new ColumnAction(NodeProperty.PTYPE));
        manager.add((IAction)new ColumnAction(NodeProperty.PDATE));
        manager.add((IAction)new ColumnAction(NodeProperty.PSIZE));
        manager.add((IAction)new ColumnAction(ZipNodeProperty.PPACKED_SIZE));
        manager.add((IAction)new ColumnAction(ZipNodeProperty.PRATIO));
        manager.add((IAction)new ColumnAction(ZipNodeProperty.PCRC));
        manager.add((IAction)new ColumnAction(NodeProperty.PPATH));
        manager.add((IAction)new ColumnAction(ZipNodeProperty.PATTR));
    }

    private void fillFoldersMenu(MenuManager manager) {
        ToggleViewModeAction foldersVisibleAction = new ToggleViewModeAction(this.fEditor, ActionMessages.getString("PreferencesAction.4"), "editor", 4);
        ToggleViewModeAction allInOneLayerAction = new ToggleViewModeAction(this.fEditor, ActionMessages.getString("PreferencesAction.5"), "editor", 8);
        allInOneLayerAction.setEnabled(foldersVisibleAction.isChecked());
        manager.add((IAction)foldersVisibleAction);
        manager.add((IAction)allInOneLayerAction);
    }

    private class ColumnAction
    extends Action {
        private int fType;
        private Integer[] fColumnsState;

        private ColumnAction(NodeProperty nodeProperty) {
            super(nodeProperty.toString());
            this.fColumnsState = (Integer[])PreferenceInitializer.split(PreferencesAction.this.fEditor.getPreferenceStore().getString("VISIBLE_COLUMNS"), ",", Integer.class);
            this.setChecked(this.indexOf(this.fColumnsState, nodeProperty.getType()) != -1);
            this.fType = nodeProperty.getType();
        }

        private int indexOf(Integer[] integers, int type) {
            int i = 0;
            while (i < integers.length) {
                if (type == integers[i]) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        private Integer[] update(Integer[] integers, boolean set) {
            int index = this.indexOf(integers, this.fType);
            if (set) {
                if (index == -1) {
                    int size = integers.length;
                    Integer[] integerArray = integers;
                    integers = new Integer[size + 1];
                    System.arraycopy(integerArray, 0, integers, 1, size);
                    integers[0] = new Integer(this.fType);
                }
            } else if (index != -1) {
                integers[index] = null;
            }
            return integers;
        }

        public void run() {
            PreferencesAction.this.fEditor.storeTableColumnPreferences();
            IPreferenceStore store = PreferencesAction.this.fEditor.getPreferenceStore();
            this.fColumnsState = this.update(this.fColumnsState, this.isChecked());
            String newValue = PreferenceInitializer.join(this.fColumnsState, ",");
            store.setValue("VISIBLE_COLUMNS", newValue);
            PreferencesAction.this.fEditor.updateView(PreferencesAction.this.fEditor.getMode(), false);
        }
    }
}

