/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.tizen.common.lv.LvPlugin;
import org.tizen.common.lv.message.LVMessages;
import org.tizen.common.lv.ui.LVLocalizationTab;
import org.tizen.common.lv.ui.LocalizationView;
import org.tizen.common.util.ImageUtil;
import org.tizen.common.util.ViewUtil;

public class LVContentTab
extends LVLocalizationTab {
    protected Composite baseComp;
    protected CTabFolder innerFolder;
    protected ToolItem itemAdd;
    protected ToolItem itemDel;
    protected ToolItem itemView;
    protected ToolBar toolbar;

    public LVContentTab(IProject project, CTabFolder parent, String tabName) {
        super(project, parent, tabName);
    }

    @Override
    public void initTab(String tabName) {
        this.setText(tabName);
        CTabFolder innerfolder = this.initInnerFolder();
        this.initTable((Composite)innerfolder);
        this.initInnerTab(innerfolder);
    }

    protected CTabFolder initInnerFolder() {
        this.baseComp = new Composite((Composite)this.folder, 0);
        this.baseComp.setLayout((Layout)new GridLayout());
        this.setControl((Control)this.baseComp);
        this.innerFolder = new CTabFolder(this.baseComp, 128);
        GridData data = new GridData(768);
        data.heightHint = 0;
        this.innerFolder.setLayoutData((Object)data);
        return this.innerFolder;
    }

    protected void initInnerTab(CTabFolder parent) {
        this.initToolbar(this.innerFolder);
    }

    protected void initToolbar(CTabFolder folder) {
        this.toolbar = new ToolBar((Composite)folder, 0x800000);
        this.itemAdd = new ToolItem(this.toolbar, 8);
        this.itemAdd.setToolTipText(LVMessages.LABEL_TOOLBAR_ADD);
        this.itemAdd.setImage(ImageUtil.getImage((Plugin)LvPlugin.getDefault(), (String)"icons/elcl16/locale_add.png"));
        this.itemAdd.setEnabled(false);
        if (LVMessages.TAB_STRING.equals(this.getText())) {
            this.itemDel = new ToolItem(this.toolbar, 8);
            this.itemDel.setToolTipText(LVMessages.LABEL_TOOLBAR_DEL);
            this.itemDel.setImage(ImageUtil.getImage((Plugin)LvPlugin.getDefault(), (String)"icons/elcl16/locale_delete.png"));
            this.itemDel.setEnabled(false);
            this.itemView = new ToolItem(this.toolbar, 8);
            this.itemView.setToolTipText(LVMessages.LABEL_TOOLBAR_VIEW);
            this.itemView.setImage(ImageUtil.getImage((Plugin)LvPlugin.getDefault(), (String)"icons/elcl16/view_mode.png"));
            this.itemView.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent arg0) {
                }

                public void widgetSelected(SelectionEvent arg0) {
                    LocalizationView view = (LocalizationView)ViewUtil.getView((String)"org.tizen.common.lv.view");
                    IProject project = view.getProject();
                    if (project != null) {
                        view.viewmodeChanged();
                    }
                }
            });
        }
        folder.setTopRight((Control)this.toolbar, 131072);
    }

    @Override
    protected void projectChanged(IProject project) {
        super.projectChanged(project);
        this.changeActAdd(project);
    }

    protected void changeActAdd(IProject project) {
        if (project == null) {
            this.itemAdd.setEnabled(false);
        } else {
            this.itemAdd.setEnabled(true);
        }
    }

    protected void changeActTool(IProject project) {
        boolean setActive = true;
        if (project == null) {
            setActive = false;
        }
        this.itemDel.setEnabled(setActive);
        this.itemView.setEnabled(setActive);
    }

    @Override
    protected void initTable(Composite composite) {
    }

    @Override
    protected void outerTabSelected() {
    }

    @Override
    protected void selectionChanged(ISelection selection) {
    }

    @Override
    protected void updateOuterTab() {
    }

    @Override
    protected void localeChanged() {
    }

    @Override
    public void viewmodeChanged() {
    }

    @Override
    public void resourceChanged() {
    }
}

