/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.ManagedForm;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ColumnLayout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.tizen.common.lv.LvPlugin;
import org.tizen.common.lv.manager.LVManager;
import org.tizen.common.lv.message.LVMessages;
import org.tizen.common.lv.model.LVLocaleVO;
import org.tizen.common.lv.ui.LVLocaleViewer;
import org.tizen.common.lv.ui.LVLocalizationTab;
import org.tizen.common.lv.ui.dialog.LVLocaleDialog;
import org.tizen.common.lv.ui.helper.ILocaleChangeListener;
import org.tizen.common.ui.dialog.FileDialogUtils;
import org.tizen.common.util.ImageUtil;

public class LVOverviewTab
extends LVLocalizationTab
implements ILocaleChangeListener {
    private LVLocaleViewer viewer;
    private Section localeSection;
    private ImageHyperlink addLocaleLink;
    private ImageHyperlink removeLocaleLink;
    private List<LVLocaleVO> localeList = null;

    public LVOverviewTab(IProject project, CTabFolder folder) {
        super(project, folder, LVMessages.TAB_OVERVIEW);
    }

    @Override
    protected void initTable(Composite parent) {
        ManagedForm form = new ManagedForm(parent);
        FormToolkit toolkit = form.getToolkit();
        ScrolledForm sc = form.getForm();
        Composite composite = sc.getBody();
        ColumnLayout bodyLayout = new ColumnLayout();
        bodyLayout.topMargin = 0;
        bodyLayout.bottomMargin = 5;
        bodyLayout.leftMargin = 10;
        bodyLayout.rightMargin = 10;
        bodyLayout.horizontalSpacing = 10;
        bodyLayout.verticalSpacing = 10;
        bodyLayout.maxNumColumns = 2;
        bodyLayout.minNumColumns = 1;
        composite.setLayout((Layout)bodyLayout);
        this.createLocaleSection(composite, toolkit);
        this.setControl((Control)sc);
    }

    private void createLocaleSection(Composite composite, FormToolkit toolkit) {
        Composite compRight = toolkit.createComposite(composite, 0);
        compRight.setLayout((Layout)new GridLayout(1, true));
        this.localeSection = this.createSection(toolkit, compRight, LVMessages.UI_LOCALE_TITLE, this.getProjectInfo());
        GridData data = new GridData(1808);
        this.localeSection.setLayoutData((Object)data);
        this.localeList = LVManager.getManager(selectedProject).getTargetLocaleListWithoutDefault();
        this.viewer = LVLocaleViewer.createViewer((Composite)this.localeSection.getClient(), this.localeList);
        this.viewer.addLocaleChangeListener(this);
        this.createLocaleToolbar(toolkit, this.localeSection);
    }

    private Section createSection(FormToolkit toolKit, Composite parent, String label, String description) {
        Section section = toolKit.createSection(parent, 400);
        section.setLayoutData((Object)new GridData(1808));
        section.setLayout((Layout)new GridLayout(1, false));
        section.setText(label);
        section.setDescription(description);
        toolKit.createCompositeSeparator((Composite)section);
        Composite client = toolKit.createComposite((Composite)section, 64);
        client.setLayoutData((Object)new GridData(1808));
        client.setLayout((Layout)new GridLayout(1, true));
        section.setClient((Control)client);
        return section;
    }

    private void createLocaleToolbar(FormToolkit toolkit, Section section) {
        final Composite toolbar = new Composite((Composite)section, 0);
        RowLayout layout = new RowLayout(256);
        toolbar.setLayout((Layout)layout);
        section.setTextClient((Control)toolbar);
        this.addLocaleLink = new ImageHyperlink(toolbar, 0);
        toolkit.adapt((Control)this.addLocaleLink, true, true);
        this.addLocaleLink.setImage(ImageUtil.getImage((Plugin)LvPlugin.getDefault(), (String)"/icons/elcl16/locale_add.png"));
        this.addLocaleLink.setToolTipText(LVMessages.UI_ADD_LOCALE_TOOLTIP);
        this.addLocaleLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LVLocaleDialog dialog = new LVLocaleDialog(toolbar.getShell(), selectedProject);
                if (dialog.open() == 0) {
                    LVOverviewTab.this.addTargetLocales(dialog.getCheckedElements());
                }
            }
        });
        this.addLocaleLink.setEnabled(false);
        this.addLocaleLink.setBackground(section.getTitleBarGradientBackground());
        this.removeLocaleLink = new ImageHyperlink(toolbar, 0);
        toolkit.adapt((Control)this.removeLocaleLink, true, true);
        this.removeLocaleLink.setImage(ImageUtil.getImage((Plugin)LvPlugin.getDefault(), (String)"/icons/elcl16/locale_delete.png"));
        this.removeLocaleLink.setToolTipText(LVMessages.UI_DELETE_LOCALE_TOOLTIP);
        this.removeLocaleLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LVOverviewTab.this.confirmRemoveTargetLocales(LVOverviewTab.this.viewer.getCheckedLocales());
            }
        });
        this.removeLocaleLink.setEnabled(false);
        this.removeLocaleLink.setBackground(section.getTitleBarGradientBackground());
        this.changeAddActivation();
    }

    private void addTargetLocales(LVLocaleVO[] selectedLocales) {
        if (selectedLocales.length > 0) {
            LVManager.getManager(selectedProject).addTargetLocales(selectedLocales);
            this.notifyLocaleChanged();
            this.changeAddActivation();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void confirmRemoveTargetLocales(LVLocaleVO[] oldLocales) {
        if (oldLocales.length <= 0) return;
        boolean yesAll = false;
        int returnCode = 0;
        if (oldLocales.length == 1) {
            returnCode = FileDialogUtils.confirmFolderDelete((String)oldLocales[0].getLanguageTag().replace('-', '_'));
            switch (returnCode) {
                case 1: {
                    return;
                }
            }
            this.removeTargetLocales(oldLocales);
            return;
        }
        ArrayList<LVLocaleVO> removeLocaleList = new ArrayList<LVLocaleVO>();
        LVLocaleVO[] lVLocaleVOArray = oldLocales;
        int n = oldLocales.length;
        int n2 = 0;
        while (n2 < n) {
            block12: {
                LVLocaleVO locale;
                block11: {
                    locale = lVLocaleVOArray[n2];
                    if (yesAll) break block11;
                    returnCode = FileDialogUtils.confirmMultiFolderDelete((String)locale.getLanguageTag().replace('-', '_'));
                    switch (returnCode) {
                        case 3: {
                            return;
                        }
                        case 2: {
                            break block12;
                        }
                        case 1: {
                            yesAll = true;
                            break;
                        }
                        case 0: 
                    }
                }
                removeLocaleList.add(locale);
            }
            ++n2;
        }
        this.removeTargetLocales(removeLocaleList.toArray(new LVLocaleVO[removeLocaleList.size()]));
    }

    private void removeTargetLocales(LVLocaleVO[] selectedLocales) {
        if (selectedLocales.length > 0) {
            LVManager.getManager(selectedProject).removeTargetLocale(selectedLocales);
            this.notifyLocaleChanged();
            this.changeRemoveActivation(this.viewer.getCheckedLocales().length);
        }
    }

    @Override
    protected void projectChanged(IProject project) {
        super.projectChanged(project);
        this.myProject = project;
        this.setDirty();
        this.updateOuterTab();
    }

    @Override
    protected void updateOuterTab() {
        if (this.isDirty) {
            this.localeSection.setDescription(this.getProjectInfo());
            this.localeSection.update();
            this.localeList = LVManager.getManager(selectedProject).getTargetLocaleListWithoutDefault();
            this.changeAddActivation();
            this.viewer.setInput(this.localeList);
            this.viewer.refresh();
            this.isDirty = false;
        }
    }

    private String getProjectInfo() {
        String desc = null;
        desc = selectedProject == null ? LVMessages.LABEL_NO_PROJECT : String.format(LVMessages.UI_LOCALE_DESC, selectedProject.getName());
        return desc;
    }

    public void changeAddActivation() {
        if (selectedProject == null) {
            this.addLocaleLink.setEnabled(false);
        } else {
            int t_cnt;
            int s_cnt = LVManager.getManager(selectedProject).getSupportLocaleMap().size();
            this.addLocaleLink.setEnabled(s_cnt != (t_cnt = LVManager.getManager(selectedProject).getTargetLocaleList().size()));
        }
    }

    public void changeRemoveActivation(int checkedCount) {
        this.removeLocaleLink.setEnabled(checkedCount > 0);
    }

    @Override
    public void viewmodeChanged() {
    }

    @Override
    protected void localeChanged() {
        this.updateOuterTab();
    }

    @Override
    protected void outerTabSelected() {
        if (this.myProject == selectedProject) {
            if (this.isDirty) {
                this.updateOuterTab();
                this.isDirty = false;
            }
        } else {
            this.myProject = selectedProject;
            this.setDirty();
            this.updateOuterTab();
        }
    }

    @Override
    protected void selectionChanged(ISelection selection) {
    }

    @Override
    public void resourceChanged() {
        this.updateOuterTab();
    }

    @Override
    public void localeChanged(Object[] objects) {
        this.changeRemoveActivation(objects.length);
    }
}

