/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.lv.manager.LVManager;
import org.tizen.common.lv.manager.LVResourceManager;
import org.tizen.common.lv.message.LVMessages;
import org.tizen.common.lv.ui.LVContentTab;
import org.tizen.common.lv.ui.LVLocalizationTab;
import org.tizen.common.lv.ui.LocalizationView;
import org.tizen.common.lv.ui.dialog.LVLocalizeResourceDialog;
import org.tizen.common.lv.ui.resource.ResourceTile;
import org.tizen.common.lv.ui.resource.ResourceTileComposite;
import org.tizen.common.util.ImageUtil;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.ViewUtil;

public class LVResourceTab
extends LVContentTab {
    private static final String LOCALE_PATH_PATTERN = "^locales/..-../(.*)";
    private Pattern localePattern = Pattern.compile("^locales/..-../(.*)");
    private final Logger logger = LoggerFactory.getLogger(LVResourceTab.class);
    private ScrolledComposite sc;
    private Composite resourceArea;
    private CTabItem defaultItem;
    private FormToolkit toolkit;
    private LVResourceManager manager;
    private Map<String, ResourceTile> resourceTileMap = new HashMap<String, ResourceTile>();
    private List<ResourceTileComposite> tileCompositeList = new ArrayList<ResourceTileComposite>();
    private static ResourceTile grayedTile = null;

    public LVResourceTab(IProject project, CTabFolder folder) {
        super(project, folder, LVMessages.TAB_RESOURCE);
        this.myProject = LVLocalizationTab.selectedProject;
        this.manager = LVManager.getManager(project).getResourceManager();
        this.toolkit = new FormToolkit(folder.getDisplay());
        this.sc = new ScrolledComposite(this.baseComp, 512);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.sc.setLayout((Layout)gridLayout);
        this.sc.setLayoutData((Object)new GridData(1808));
        this.resourceArea = new Composite((Composite)this.sc, 0);
        gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.resourceArea.setLayout((Layout)gridLayout);
        this.resourceArea.setLayoutData((Object)new GridData(1808));
        this.resourceArea.setBackground(Display.getCurrent().getSystemColor(1));
        this.sc.setContent((Control)this.resourceArea);
        this.sc.setExpandHorizontal(true);
        this.sc.setExpandVertical(true);
        this.sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent paramControlEvent) {
                LVResourceTab.this.sc.setMinWidth(((LVResourceTab)LVResourceTab.this).sc.getSize().x);
                LVResourceTab.this.sc.setMinHeight(((LVResourceTab)LVResourceTab.this).resourceArea.computeSize((int)-1, (int)-1).y);
            }
        });
    }

    @Override
    protected void initInnerTab(CTabFolder parent) {
        super.initInnerTab(parent);
        parent.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                String currentLocale = LVResourceTab.this.innerFolder.getSelection().getText();
                for (ResourceTileComposite tileComp : LVResourceTab.this.tileCompositeList) {
                    tileComp.localeChanged(currentLocale);
                }
                LVResourceTab.this.resourceArea.redraw(0, ((LVResourceTab)LVResourceTab.this).sc.getOrigin().y, ((LVResourceTab)LVResourceTab.this).sc.getSize().x, ((LVResourceTab)LVResourceTab.this).sc.getSize().y, true);
                LVResourceTab.this.sc.setMinHeight(((LVResourceTab)LVResourceTab.this).resourceArea.computeSize((int)-1, (int)-1).y);
            }
        });
        this.defaultItem = new CTabItem(parent, 0);
        this.defaultItem.setText("default");
        parent.setSelection(0);
    }

    @Override
    protected void initToolbar(CTabFolder folder) {
        super.initToolbar(folder);
        this.itemAdd.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                Shell shell = SWTUtil.getActiveShell();
                LocalizationView view = (LocalizationView)ViewUtil.getView((String)"org.tizen.common.lv.view");
                IProject project = view.getProject();
                if (project == null) {
                    return;
                }
                LVLocalizeResourceDialog dialog = new LVLocalizeResourceDialog(shell, project);
                dialog.open();
            }
        });
    }

    @Override
    protected void initTable(Composite composite) {
    }

    private void makeLocaleTabItems() {
        for (IResource localeFolder : this.manager.getLocaleFolderList()) {
            CTabItem item = new CTabItem(this.innerFolder, 0);
            item.setText(localeFolder.getName());
            item.setImage(this.getFlag(localeFolder.getName()));
        }
    }

    private Image getFlag(String locale) {
        return ImageUtil.getImage((String)"org.tizen.common.lv", (String)("icons/flags/" + locale.split("-")[1] + "/flag.png"));
    }

    private void makeResourceTile(String currentLocale) {
        this.resourceTileMap.clear();
        this.tileCompositeList.clear();
        Map<String, List<String>> defaultResourceMap = this.manager.getDefaultResourceMap();
        List<String> resourceList = defaultResourceMap.get("");
        if (resourceList == null) {
            return;
        }
        ResourceTileComposite tileComp = new ResourceTileComposite(this.resourceArea);
        tileComp.setLayoutData(new GridData(768));
        this.tileCompositeList.add(tileComp);
        for (String resource : resourceList) {
            this.resourceTileMap.put(resource, tileComp.addResource(this.myProject, resource, currentLocale));
        }
        for (String folderPath : this.manager.getDefaultChildFolderPathList()) {
            resourceList = defaultResourceMap.get(folderPath);
            if (resourceList == null || resourceList.size() == 0) continue;
            Section section = this.toolkit.createSection(this.resourceArea, 322);
            section.setLayoutData((Object)new GridData(768));
            section.setText(folderPath);
            tileComp = new ResourceTileComposite((Composite)section);
            tileComp.setLayoutData(new GridData(768));
            section.setClient((Control)tileComp);
            this.tileCompositeList.add(tileComp);
            for (String resource : resourceList) {
                this.resourceTileMap.put(resource, tileComp.addResource(this.myProject, resource, currentLocale));
            }
            section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent event) {
                    LVResourceTab.this.sc.setMinHeight(((LVResourceTab)LVResourceTab.this).resourceArea.computeSize((int)-1, (int)-1).y);
                }
            });
        }
        this.resourceArea.layout();
    }

    @Override
    protected void updateOuterTab() {
        String currentLocale = this.innerFolder.getSelection().getText();
        if (this.manager == null) {
            return;
        }
        if (this.manager.isDirty()) {
            this.drawResourceTiles(currentLocale);
            this.manager.setDirty(false);
        }
        CTabItem[] cTabItemArray = this.innerFolder.getItems();
        int n = cTabItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            CTabItem item = cTabItemArray[n2];
            if (item.getText().equals(currentLocale)) {
                this.innerFolder.setSelection(item);
                this.resourceArea.layout();
                this.resourceArea.redraw(0, this.sc.getOrigin().y, this.sc.getSize().x, this.sc.getSize().y, true);
                this.sc.setMinHeight(this.resourceArea.computeSize((int)-1, (int)-1).y);
                break;
            }
            ++n2;
        }
    }

    @Override
    protected void outerTabSelected() {
        this.changeActAdd(selectedProject);
        if (LVLocalizationTab.selectedProject == null) {
            this.myProject = null;
            this.manager = null;
            grayedTile = null;
            this.cleanResourceUI();
            this.resourceArea.layout();
            this.sc.setMinHeight(this.resourceArea.computeSize((int)-1, (int)-1).y);
            return;
        }
        if (this.myProject == null || !this.myProject.equals((Object)LVLocalizationTab.selectedProject)) {
            this.myProject = LVLocalizationTab.selectedProject;
            this.manager = LVManager.getManager(this.myProject).getResourceManager();
            this.manager.setDirty(true);
        }
        if (this.manager.isDirty()) {
            this.drawResourceTiles(this.innerFolder.getSelection().getText());
            this.sc.setOrigin(-1, 0);
            this.manager.setDirty(false);
        }
    }

    @Override
    protected void projectChanged(IProject project) {
        this.myProject = project;
        super.projectChanged(this.myProject);
        if (this.myProject == null) {
            this.manager = null;
            grayedTile = null;
            this.cleanResourceUI();
            this.resourceArea.layout();
            this.sc.setMinHeight(this.resourceArea.computeSize((int)-1, (int)-1).y);
            return;
        }
        if (this.manager != null) {
            this.manager.setDirty(true);
        }
        this.manager = LVManager.getManager(this.myProject).getResourceManager();
        this.drawResourceTiles("default");
        this.sc.setOrigin(-1, 0);
        this.manager.setDirty(false);
    }

    @Override
    protected void selectionChanged(ISelection selection) {
        Object file;
        if (grayedTile != null && !grayedTile.isDisposed()) {
            grayedTile.removeGray();
        }
        String path = null;
        if (selection instanceof IStructuredSelection && (file = ((IStructuredSelection)selection).getFirstElement()) instanceof IFile) {
            path = ((IFile)file).getProjectRelativePath().toOSString();
        }
        if (path == null) {
            return;
        }
        Matcher matcher = this.localePattern.matcher(path);
        if (matcher.find()) {
            path = matcher.group(1);
        }
        if ((grayedTile = this.resourceTileMap.get(path)) == null) {
            return;
        }
        grayedTile.setGray();
        int tileTopY = 0;
        int tileBottomY = LVResourceTab.grayedTile.getSize().y;
        Composite parent = grayedTile.getParent().getParent();
        if (parent instanceof Section) {
            Section section = (Section)parent;
            if (!section.isExpanded()) {
                section.setExpanded(true);
            }
            tileTopY += section.getLocation().y + section.getSize().y - section.getClient().getSize().y;
        }
        tileBottomY += (tileTopY += LVResourceTab.grayedTile.getLocation().y);
        int originY = this.sc.getOrigin().y;
        if (tileTopY < originY) {
            this.sc.setOrigin(-1, tileTopY);
        } else if (tileBottomY > originY + this.sc.getSize().y) {
            this.sc.setOrigin(-1, tileBottomY - this.sc.getSize().y);
        }
    }

    private void cleanResourceUI() {
        CTabItem[] items = this.innerFolder.getItems();
        int i = 1;
        while (i < items.length) {
            items[i].dispose();
            items[i] = null;
            ++i;
        }
        Control[] controlArray = this.resourceArea.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            Object var2_3 = null;
            ++n2;
        }
    }

    private void drawResourceTiles(String currentLocale) {
        this.cleanResourceUI();
        this.makeLocaleTabItems();
        this.makeResourceTile(currentLocale);
        this.innerFolder.setSelection(0);
        this.resourceArea.layout();
        this.sc.setMinHeight(this.resourceArea.computeSize((int)-1, (int)-1).y);
    }

    @Override
    public void viewmodeChanged() {
    }

    @Override
    protected void localeChanged() {
    }

    public static ResourceTile getGrayedTile() {
        return grayedTile;
    }

    public static void setGrayedTile(ResourceTile grayedTile) {
        LVResourceTab.grayedTile = grayedTile;
    }

    @Override
    public void resourceChanged() {
        this.updateOuterTab();
    }
}

