/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.ui.dialog;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.lv.manager.LVManager;
import org.tizen.common.lv.message.LVMessages;
import org.tizen.common.lv.model.LVLocaleVO;
import org.tizen.common.lv.ui.LVLocaleViewer;
import org.tizen.common.lv.ui.dialog.LVAbstractDialog;
import org.tizen.common.util.StringUtil;

public class LVLocaleDialog
extends LVAbstractDialog {
    private LVLocaleViewer viewer;
    private LVLocaleVO[] locales;
    private List<LVLocaleVO> currentList;
    private Map<String, LVLocaleVO> supportMap;

    public LVLocaleDialog(Shell parentShell, IProject project) {
        super(parentShell, LVMessages.UI_ADD_LOCALE_TITLE, LVMessages.UI_ADD_LOCALE_DESC);
        this.currentList = LVManager.getManager(project).getTargetLocaleList();
        this.supportMap = LVManager.getManager(project).getSupportLocaleMap();
    }

    protected void okPressed() {
        this.locales = this.viewer.getCheckedLocales();
        super.okPressed();
    }

    public LVLocaleVO[] getCheckedElements() {
        return this.locales;
    }

    public List<LVLocaleVO> getTableList() {
        ArrayList<LVLocaleVO> tableList = new ArrayList<LVLocaleVO>();
        boolean isExist = false;
        for (LVLocaleVO svo : this.supportMap.values()) {
            isExist = false;
            for (LVLocaleVO cvo : this.currentList) {
                if (!svo.equals(cvo)) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            tableList.add(svo);
        }
        return tableList;
    }

    @Override
    protected void createInput(Composite composite) {
        Composite compTop = new Composite(composite, 0);
        compTop.setLayoutData((Object)new GridData(768));
        compTop.setLayout((Layout)new GridLayout(2, false));
        Label lblName = new Label(compTop, 0);
        lblName.setText(LVMessages.UI_ADD_LOCALE_FILTER);
        final Text txtName = new Text(compTop, 2048);
        txtName.setLayoutData((Object)new GridData(768));
        txtName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                String text = txtName.getText();
                LVLocaleDialog.this.resetLocaleTable(text);
            }
        });
    }

    private void resetLocaleTable(String key) {
        List<LVLocaleVO> checkedList = this.viewer.getCheckedList();
        if (StringUtil.isEmpty((CharSequence)key)) {
            this.viewer.setInput(this.getTableList());
            for (LVLocaleVO locale : checkedList) {
                this.viewer.setSuperChecked(locale, true);
            }
            this.viewer.deleteCheckedList();
        } else {
            ArrayList<LVLocaleVO> localeList = new ArrayList<LVLocaleVO>();
            List<LVLocaleVO> tableList = this.getTableList();
            key = key.toLowerCase();
            for (LVLocaleVO locale : tableList) {
                if (!locale.getLanguageTag().toLowerCase().contains(key) && !locale.getLanguage().toLowerCase().contains(key) && !locale.getRegion().toLowerCase().contains(key)) continue;
                localeList.add(locale);
            }
            this.viewer.setInput(localeList);
            for (LVLocaleVO locale : checkedList) {
                this.viewer.setSuperChecked(locale, true);
            }
        }
        this.viewer.refresh();
    }

    @Override
    protected void createTable(Composite composite) {
        Composite compBot = new Composite(composite, 0);
        compBot.setLayoutData((Object)new GridData(1808));
        compBot.setLayout((Layout)new GridLayout(1, false));
        this.viewer = LVLocaleViewer.createViewer(compBot, this.getTableList());
        this.viewer.refresh();
    }
}

