/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.ui.resource;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.tizen.common.lv.ui.resource.ResourceTile;

public class ResourceTileComposite
extends Composite {
    private static final int TILE_WIDTH = 100;
    private static final int TILE_HEIGHT = 100;
    private List<ResourceTile> resourceTileList = new ArrayList<ResourceTile>();

    public ResourceTileComposite(Composite parent) {
        super(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        this.setBackground(Display.getCurrent().getSystemColor(1));
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                GridLayout gridLayout = (GridLayout)ResourceTileComposite.this.getLayout();
                gridLayout.numColumns = ResourceTileComposite.this.getSize().x / (100 + gridLayout.horizontalSpacing);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent paramMouseEvent) {
                ResourceTileComposite.this.setFocus();
            }
        });
    }

    public void localeChanged(String locale) {
        for (ResourceTile tile : this.resourceTileList) {
            tile.setLocale(locale);
        }
    }

    public ResourceTile addResource(IProject project, String filePath, String locale) {
        ResourceTile tile = new ResourceTile(this, project, filePath, locale);
        tile.setToolTipText(filePath);
        GridData gridData = new GridData();
        gridData.widthHint = 100;
        gridData.heightHint = 100;
        tile.setLayoutData(gridData);
        this.resourceTileList.add(tile);
        return tile;
    }
}

