/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.logview.service;

import org.apache.log4j.Logger;
import org.tizen.common.connection.logview.service.DeviceStateType;
import org.tizen.common.connection.logview.service.DeviceType;
import org.tizen.sdblib.IDevice;

public class DeviceDescriptor
implements Comparable<DeviceDescriptor> {
    private DeviceType deviceType;
    private DeviceStateType deviceState;
    private IDevice device;
    private String serialId;
    private String descriptorName;
    private String tooltipName;
    private String deviceName;
    private String platformName;
    private String resolution;
    private String deviceStateName;
    private String profileName;

    public DeviceDescriptor(String deviceSerial) {
        this.serialId = deviceSerial;
    }

    public DeviceDescriptor(String deviceSerial, String descriptorName) {
        this(deviceSerial);
        this.descriptorName = descriptorName;
    }

    public DeviceDescriptor(String deviceSerial, IDevice device) {
        this(deviceSerial);
        this.device = device;
    }

    public void setIDevice(IDevice device) {
        this.device = device;
    }

    public IDevice getIDevice() {
        return this.device;
    }

    public String getSerialId() {
        return this.serialId;
    }

    public void setSerialId(String serialId) {
        this.serialId = serialId;
    }

    @Override
    public int compareTo(DeviceDescriptor object) {
        DeviceDescriptor other = object;
        return Integer.compare(this.getItemGroup(this.deviceType), this.getItemGroup(other.deviceType));
    }

    private int getItemGroup(DeviceType type) {
        if (type == DeviceType.LOCAL_DEVICE) {
            return 1;
        }
        if (type == DeviceType.LOCAL_EMULATOR) {
            return 2;
        }
        if (type == DeviceType.REMOTE_DEVICE | type == DeviceType.REMOTE_EMULATOR) {
            return 3;
        }
        return 0;
    }

    public String getDescriptorName() {
        return this.descriptorName;
    }

    public void setDescriptorName(String descriptorName) {
        this.descriptorName = descriptorName;
    }

    public DeviceStateType getDeviceStateType() {
        return this.deviceState;
    }

    public void setDeviceStateType(DeviceStateType deviceState) {
        this.deviceState = deviceState;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public void setDeviceType(DeviceType deviceType) {
        this.deviceType = deviceType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyIDeviceCreated() {
        DeviceDescriptor deviceDescriptor = this;
        synchronized (deviceDescriptor) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IDevice getIDevice(boolean blocking, int waitSec) {
        if (!blocking) {
            return this.getIDevice();
        }
        DeviceDescriptor deviceDescriptor = this;
        synchronized (deviceDescriptor) {
            try {
                this.wait(waitSec);
            }
            catch (InterruptedException e) {
                Logger.getLogger(DeviceDescriptor.class).warn((Object)("It is interrupted before main thread invokes: " + e));
            }
        }
        return this.device;
    }

    public String getTooltipName() {
        return this.tooltipName;
    }

    public void setTooltipName(String tooltipName) {
        this.tooltipName = tooltipName;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public String getDeviceStateName() {
        return this.deviceStateName;
    }

    public void setDeviceStateName(String deviceStateName) {
        this.deviceStateName = deviceStateName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }
}

