/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.logview.view;

import java.text.SimpleDateFormat;
import java.util.Date;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import org.tizen.common.connection.logview.resources.ROW_STATE;
import org.tizen.common.connection.logview.service.DeviceDescriptor;
import org.tizen.common.connection.logview.service.DeviceType;
import org.tizen.common.connection.logview.service.DeviceTypeImageData;

public class DeviceItem
implements Cloneable {
    private final SimpleStringProperty name = new SimpleStringProperty("");
    private final SimpleStringProperty platform = new SimpleStringProperty("");
    private final SimpleStringProperty port = new SimpleStringProperty("");
    private final SimpleStringProperty connect = new SimpleStringProperty("");
    private final SimpleObjectProperty<ROW_STATE> rowState = new SimpleObjectProperty((Object)ROW_STATE.NORMAL);
    private DeviceDescriptor deviceDesc = null;
    private DeviceTypeImageData deviceTypeImageData = null;
    private DeviceType deviceType = null;

    public boolean equals(Object obj) {
        if (!(obj instanceof DeviceItem)) {
            return false;
        }
        DeviceItem item = (DeviceItem)obj;
        return this.port.get().equals(item.getPort());
    }

    public DeviceItem(DeviceDescriptor deviceInfo) {
        this.setValue(deviceInfo);
        this.setProfileImageData(deviceInfo.getDeviceType());
    }

    public void setValue(DeviceDescriptor deviceInfo) {
        this.deviceDesc = deviceInfo;
        this.name.set(deviceInfo.getDeviceName());
        this.platform.set(deviceInfo.getPlatformName());
        this.port.set(deviceInfo.getSerialId() == null ? "" : deviceInfo.getSerialId());
        this.connect.set(deviceInfo.getDeviceStateType().name());
        this.deviceType = deviceInfo.getDeviceType();
    }

    public SimpleStringProperty connectProperty() {
        return this.connect;
    }

    public SimpleStringProperty nameProperty() {
        return this.name;
    }

    public SimpleStringProperty platformProperty() {
        return this.platform;
    }

    public String getConnect() {
        return this.connect.get();
    }

    public String getName() {
        return this.name.get();
    }

    public String getPlatform() {
        return this.platform.get();
    }

    public String getPort() {
        return this.port.get();
    }

    public SimpleObjectProperty<ROW_STATE> getRowState() {
        return this.rowState;
    }

    public String toString() {
        return this.port.get();
    }

    public String getPlatformTooltip() {
        String tooltip = "platform tool tip";
        return tooltip;
    }

    public String getProfile() {
        return this.deviceDesc.getProfileName();
    }

    public DeviceDescriptor getDeviceDescriptor() {
        return this.deviceDesc;
    }

    public void setRowState(ROW_STATE state) {
        this.rowState.set((Object)state);
    }

    public DeviceTypeImageData getDeviceTypeImageData() {
        return this.deviceTypeImageData;
    }

    public void setProfileImageData(DeviceTypeImageData deviceTypeImageData) {
        this.deviceTypeImageData = deviceTypeImageData;
    }

    public void setProfileImageData(DeviceType deviceType) {
        DeviceTypeImageData deviceTypeImageData = new DeviceTypeImageData(deviceType);
        this.setProfileImageData(deviceTypeImageData);
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public String getDateTooltip() {
        String tooltip = "";
        SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd HH:mm");
        tooltip = "Last modified: " + format.format(new Date());
        return tooltip;
    }

    public String getDisplayDeviceName() {
        return String.valueOf(this.getPort()) + " (" + this.getName() + ")";
    }
}

