/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.model.run;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.model.run.Cookie;
import org.tizen.common.rest.util.OutputUtil;
import org.tizen.common.rest.util.StringUtil;

public class ResponseModel
implements Serializable {
    private static final long serialVersionUID = 7693199189927926869L;
    private int responseCode;
    private String responseMessage;
    private String exceptionMessage;
    private Map<String, String> headers;
    private List<Cookie> cookies;
    private long contentLength;
    private String contents;
    private String mimeType;

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(String responseMessage) {
        this.responseMessage = responseMessage;
    }

    public String getExceptionMessage() {
        return this.exceptionMessage;
    }

    public void setExceptionMessage(String exceptionMessage) {
        this.exceptionMessage = exceptionMessage;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public void setCookies(List<Cookie> cookies) {
        this.cookies = cookies;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(long contentLength) {
        this.contentLength = contentLength;
    }

    public String getContents() {
        return this.contents;
    }

    public void setContents(String contents) {
        this.contents = contents;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String toPrintableString() {
        StringBuilder builder = new StringBuilder();
        String lf = StringUtil.getLineSeparator();
        builder.append("##### Response Infomation #####" + lf);
        if (this.getExceptionMessage() != null && this.getExceptionMessage().length() > 0) {
            builder.append("\t### Exception message ###" + lf);
            builder.append("\t\t" + this.getExceptionMessage() + lf);
        }
        if (this.getHeaders() != null && this.getHeaders().size() > 0) {
            builder.append("\t### Response Headers ### " + lf);
            for (Map.Entry entry : this.getHeaders().entrySet()) {
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                builder.append("\t\t" + key + " = " + value + lf);
            }
        }
        if (this.getCookies() != null && this.getCookies().size() > 0) {
            builder.append("\t### Response Cookies ### " + lf);
            for (Cookie cookie : this.getCookies()) {
                builder.append("\t\t" + StringUtil.getCookieData(cookie) + lf);
            }
        }
        builder.append("\t### Response Basic Information ###" + lf);
        builder.append("\t\tResponse code : " + this.getResponseCode() + lf);
        builder.append("\t\tResponse Message : " + this.getResponseMessage() + lf);
        builder.append("\t\tContents length : " + this.getContentLength() + " bytes" + lf);
        builder.append("\t### Contents ###" + lf);
        String contents = String.valueOf(this.getContents()) + lf;
        if (ContentType.APPLICATION_XML.getMimeType().equalsIgnoreCase(this.getMimeType()) || ContentType.TEXT_XML.getMimeType().equalsIgnoreCase(this.getMimeType()) || ContentType.APPLICATION_ATOM_XML.getMimeType().equalsIgnoreCase(this.getMimeType()) || ContentType.APPLICATION_SVG_XML.getMimeType().equalsIgnoreCase(this.getMimeType()) || ContentType.APPLICATION_XHTML_XML.getMimeType().equalsIgnoreCase(this.getMimeType())) {
            contents = String.valueOf(OutputUtil.toPrettyXml(this.getContents())) + lf;
        } else if (ContentType.APPLICATION_JSON.getMimeType().equalsIgnoreCase(this.getMimeType())) {
            try {
                contents = String.valueOf(OutputUtil.toPrettyJson(this.getContents())) + lf;
            }
            catch (Exception exception) {
                RestPlugin.log(exception);
            }
        } else {
            try {
                contents = String.valueOf(OutputUtil.toPrettyJson(this.getContents())) + lf;
            }
            catch (Exception exception) {
                RestPlugin.log(exception);
            }
        }
        builder.append(contents);
        return builder.toString();
    }
}

