/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.model.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.tizen.common.rest.model.schema.AbstractWadlModel;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.Doc;
import org.tizen.common.rest.model.schema.IRestUiModel;
import org.tizen.common.rest.model.schema.IWadlModel;
import org.tizen.common.rest.model.schema.Resource;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"doc", "resource", "any"})
@XmlRootElement(name="resources")
public class Resources
extends AbstractWadlModel
implements IRestUiModel {
    protected List<Doc> doc;
    @XmlElement(required=true)
    protected List<Resource> resource;
    @XmlAnyElement(lax=true)
    protected List<Object> any;
    @XmlAttribute(name="base")
    @XmlSchemaType(name="anyURI")
    protected String base;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public Resources() {
    }

    public Resources(String base) {
        this.base = base;
    }

    @Override
    public List<IWadlModel> getChildren() {
        ArrayList<IWadlModel> list = new ArrayList<IWadlModel>();
        list.addAll(this.getDoc());
        list.addAll(this.getResource());
        return list;
    }

    public List<Doc> getDoc() {
        if (this.doc == null) {
            this.doc = new ArrayList<Doc>();
        }
        return this.doc;
    }

    public List<Resource> getResource() {
        if (this.resource == null) {
            this.resource = new ArrayList<Resource>();
        }
        return this.resource;
    }

    public List<Object> getAny() {
        if (this.any == null) {
            this.any = new ArrayList<Object>();
        }
        return this.any;
    }

    public String getBase() {
        return this.base;
    }

    public void setBase(String value) {
        this.base = value;
    }

    public void setTitle(String value) {
        List<Doc> docList = this.getDoc();
        super.setTitle(docList, value);
    }

    public String getTitle() {
        return super.getTitle(this.getDoc());
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    @Override
    public void addChild(IRestUiModel model) {
        if (model instanceof Resource) {
            Resource resource = (Resource)model;
            this.getResource().add(resource);
            resource.setParent(this);
        }
    }

    @Override
    public void removeChild(IRestUiModel model) {
        if (model instanceof Resource) {
            Resource resource = (Resource)model;
            this.getResource().remove(model);
            resource.setParent(null);
        }
    }

    @Override
    public boolean isVaildChild(IRestUiModel model) {
        return model instanceof Resource;
    }

    @Override
    public IRestUiModel update(IRestUiModel updateModel) {
        if (updateModel instanceof Resources) {
            Resources rs = (Resources)updateModel;
            this.base = rs.getBase();
            this.setTitle(rs.getTitle());
            return this;
        }
        return null;
    }

    @Override
    public void delete() {
        Application application = this.getRoot();
        if (application != null) {
            application.removeChild(this);
        }
    }

    @Override
    public String getElementId() {
        return this.getBase();
    }

    @Override
    public String getDisplayName() {
        return "BaseURL";
    }

    @Override
    public void insertBefore(IRestUiModel model, IRestUiModel target) {
        this.insert(model, target, true);
    }

    @Override
    public void insertAfter(IRestUiModel model, IRestUiModel target) {
        this.insert(model, target, false);
    }

    private void insert(IRestUiModel model, IRestUiModel target, boolean isBefore) {
        int index;
        if (model instanceof Resource && target instanceof Resource && (index = this.getResource().indexOf(target)) > -1) {
            Resource res = (Resource)model;
            this.getResource().add(isBefore ? index : index + 1, res);
            res.setParent(this);
        }
    }
}

