/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.dialogs;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.ui.dialogs.AbstractStringsAddDialog;

public class PrefVariableAddDialog
extends AbstractStringsAddDialog {
    private static final String TITLE = "New Variable";
    protected Text keyText;
    protected Text valText;

    public PrefVariableAddDialog(Shell parent) {
        super(parent, TITLE);
    }

    @Override
    protected void createContents(final Shell shell) {
        Label lblName = new Label((Composite)shell, 0);
        lblName.setText(String.valueOf(RestUIMessages.UserVariablesPreferencePage_table_name_label) + " :");
        this.keyText = this.createText((Composite)shell, 300, true);
        this.keyText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String str = PrefVariableAddDialog.this.keyText.getText();
                boolean containDot = str.contains(".");
                PrefVariableAddDialog.this.getBtnOk().setEnabled(!containDot);
                if (containDot) {
                    MessageDialog.openWarning((Shell)shell, (String)"Invalid input", (String)"Dot(.) is not a valid identifier");
                    PrefVariableAddDialog.this.keyText.selectAll();
                }
            }
        });
        Label lblValue = new Label((Composite)shell, 0);
        lblValue.setText(String.valueOf(RestUIMessages.UserVariablesPreferencePage_table_value_label) + " :");
        this.valText = this.createText((Composite)shell, 300, true);
        this.valText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 13 && PrefVariableAddDialog.this.updateOkButtonState()) {
                    PrefVariableAddDialog.this.updateResult();
                    PrefVariableAddDialog.this.close();
                }
            }
        });
    }

    @Override
    protected Control getFirstFocusControl() {
        return this.keyText;
    }

    @Override
    protected String[] makeResult() {
        return new String[]{this.keyText.getText(), this.valText.getText()};
    }
}

