/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.preferences;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.model.RepositoryManager;
import org.tizen.common.rest.ui.preferences.AbstractPreferencePage;

public class RestPreferencePage
extends AbstractPreferencePage {
    public static final String ID_PREFERENCE = "org.tizen.common.rest.ui.preferences.rest";
    private Group repoGroup;
    private Text repoPathText;
    private Button repoBrowseBtn;

    public RestPreferencePage() {
        super(RestUIMessages.RestPreferencePage_description);
    }

    @Override
    protected Composite createContentArea(Composite parent) {
        int nColumns = 1;
        Composite composite = this.createComposite(parent, nColumns);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createRepositoryContent(composite);
        return composite;
    }

    private void createRepositoryContent(Composite parent) {
        this.repoGroup = new Group(parent, 0);
        this.repoGroup.setText(RestUIMessages.RestPreferencePage_repo_group_name);
        this.repoGroup.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertVerticalDLUsToPixels(4);
        this.repoGroup.setLayout((Layout)layout);
        Composite noteComp = this.createNoteComposite(JFaceResources.getDialogFont(), (Composite)this.repoGroup, "Note: ", RestUIMessages.RestPreferencePage_repoDesc_text);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        noteComp.setLayoutData((Object)gd);
        Label repoLabel = new Label((Composite)this.repoGroup, 0);
        repoLabel.setText(RestUIMessages.RestPreferencePage_repoLabel_text);
        this.repoPathText = this.createText((Composite)this.repoGroup, 2052, "PREF_KEY_REPO_PATH", 80, 1);
        this.repoPathText.setLayoutData((Object)new GridData(768));
        this.repoPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                RestPreferencePage.this.validate();
            }
        });
        this.repoBrowseBtn = this.createButton((Composite)this.repoGroup, RestUIMessages.RestPreferencePage_repoBrowseBtn_text, 0, 0);
        this.repoBrowseBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog dialog = new DirectoryDialog(RestPreferencePage.this.getShell());
                String folder = dialog.open();
                if (folder != null && folder.length() > 0) {
                    RestPreferencePage.this.repoPathText.setText(folder);
                }
            }
        });
    }

    @Override
    protected void loadData() {
    }

    protected void validate() {
        boolean isValid = true;
        String message = null;
        if (this.repoPathText.getText().length() == 0) {
            isValid = false;
            message = RestUIMessages.RunPreferencePage_repoPath_empty_message;
        }
        this.setValid(isValid);
        if (message != null) {
            this.setErrorMessage(message);
        } else {
            this.setErrorMessage(null);
        }
    }

    @Override
    protected void performApply() {
        String oldRepoPath = this.getValue("PREF_KEY_REPO_PATH");
        String newRepoPath = this.repoPathText.getText();
        this.setValue("PREF_KEY_REPO_PATH", newRepoPath);
        if (!newRepoPath.equals(oldRepoPath)) {
            RepositoryManager.getInstance().reloadRepository(true);
        }
    }

    protected void performDefaults() {
        this.repoPathText.setText(this.getDefault("PREF_KEY_REPO_PATH"));
        super.performDefaults();
    }
}

