/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.dialogs.WizardDataTransferPage;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.ui.wizards.AbstractOperation;

public abstract class AbstractFileExportWizardPage
extends WizardDataTransferPage {
    private Application selectedApplication;
    private Combo destinationNameField;
    private Button destinationBrowseButton;

    public AbstractFileExportWizardPage(String name, IStructuredSelection selection, String title, String description) {
        super(name);
        this.setTitle(title);
        this.setDescription(description);
        this.selectedApplication = (Application)selection.getFirstElement();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.createDestinationGroup(composite);
        this.createOptionsGroup(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setErrorMessage(null);
        this.setControl((Control)composite);
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    protected void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(this.getStoreDestinationNameId());
            if (directoryNames == null || directoryNames.length == 0) {
                return;
            }
            this.setDestinationValue(directoryNames[0]);
            int i = 0;
            while (i < directoryNames.length) {
                this.addDestinationItem(directoryNames[i]);
                ++i;
            }
        }
    }

    protected void updateWidgetEnablements() {
        boolean pageComplete = this.determinePageCompletion();
        this.setPageComplete(pageComplete);
        if (pageComplete) {
            this.setMessage(null);
        }
        super.updateWidgetEnablements();
    }

    protected String getErrorDialogTitle() {
        return IDEWorkbenchMessages.WizardExportPage_errorDialogTitle;
    }

    protected abstract String getStoreDestinationNameId();

    protected abstract AbstractOperation createExportOperation(Application var1, String var2);

    protected abstract String getOutputSuffix();

    protected abstract String[] getFileDialogFilterExtensions();

    protected abstract String selectDestinationTitleMessage();

    protected void createDestinationGroup(Composite parent) {
        Font font = parent.getFont();
        Composite destinationSelectionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        destinationSelectionGroup.setLayout((Layout)layout);
        destinationSelectionGroup.setLayoutData((Object)new GridData(768));
        destinationSelectionGroup.setFont(font);
        Label destinationLabel = new Label(destinationSelectionGroup, 0);
        destinationLabel.setText(this.getDestinationLabel());
        destinationLabel.setFont(font);
        this.destinationNameField = new Combo(destinationSelectionGroup, 2052);
        this.destinationNameField.addListener(24, (Listener)this);
        this.destinationNameField.addListener(13, (Listener)this);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.destinationNameField.setLayoutData((Object)data);
        this.destinationNameField.setFont(font);
        this.destinationBrowseButton = new Button(destinationSelectionGroup, 8);
        this.destinationBrowseButton.setText(DataTransferMessages.DataTransfer_browse);
        this.destinationBrowseButton.addListener(13, (Listener)this);
        this.destinationBrowseButton.setFont(font);
        this.setButtonLayoutData(this.destinationBrowseButton);
        new Label(parent, 0);
    }

    protected String getDestinationLabel() {
        return DataTransferMessages.FileExport_toDirectory;
    }

    protected void giveFocusToDestination() {
        this.destinationNameField.setFocus();
    }

    public void handleEvent(Event e) {
        Widget source = e.widget;
        if (source == this.destinationBrowseButton) {
            this.handleDestinationBrowseButtonPressed();
        }
        this.updatePageCompletion();
    }

    protected void createOptionsGroup(Composite parent) {
    }

    protected boolean ensureTargetDirectoryIsValid(String fullPathname) {
        int separatorIndex = fullPathname.lastIndexOf(File.separator);
        if (separatorIndex == -1) {
            return true;
        }
        return this.ensureTargetIsValid(new File(fullPathname.substring(0, separatorIndex)));
    }

    protected boolean ensureTargetFileIsValid(File targetFile) {
        if (targetFile.exists() && targetFile.isDirectory()) {
            this.displayErrorDialog(DataTransferMessages.ZipExport_mustBeFile);
            this.giveFocusToDestination();
            return false;
        }
        if (targetFile.exists()) {
            if (targetFile.canWrite()) {
                if (!this.queryYesNoQuestion(DataTransferMessages.ZipExport_alreadyExists)) {
                    return false;
                }
            } else {
                this.displayErrorDialog(DataTransferMessages.ZipExport_alreadyExistsError);
                this.giveFocusToDestination();
                return false;
            }
        }
        return true;
    }

    protected boolean ensureTargetIsValid() {
        String targetPath = this.getDestinationValue();
        if (!this.ensureTargetDirectoryIsValid(targetPath)) {
            return false;
        }
        return this.ensureTargetFileIsValid(new File(targetPath));
    }

    protected boolean ensureDirectoryExists(File directory) {
        if (!directory.exists()) {
            if (!this.queryYesNoQuestion(DataTransferMessages.DataTransfer_createTargetDirectory)) {
                return false;
            }
            if (!directory.mkdirs()) {
                this.displayErrorDialog(DataTransferMessages.DataTransfer_directoryCreationError);
                this.giveFocusToDestination();
                return false;
            }
        }
        return true;
    }

    protected boolean ensureTargetIsValid(File targetDirectory) {
        if (targetDirectory.exists() && !targetDirectory.isDirectory()) {
            this.displayErrorDialog(DataTransferMessages.FileExport_directoryExists);
            this.giveFocusToDestination();
            return false;
        }
        return this.ensureDirectoryExists(targetDirectory);
    }

    protected boolean executeExportOperation(AbstractOperation op) {
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            this.displayErrorDialog(e.getTargetException());
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)DataTransferMessages.DataTransfer_exportProblems, null, (IStatus)status);
            return false;
        }
        return true;
    }

    public boolean finish() {
        if (!this.ensureTargetIsValid()) {
            return false;
        }
        this.saveWidgetValues();
        return this.executeExportOperation(this.createExportOperation(this.selectedApplication, this.getDestinationValue()));
    }

    protected String getDestinationValue() {
        String idealSuffix = this.getOutputSuffix();
        String destinationText = this.destinationNameField.getText().trim();
        if (destinationText.length() != 0 && !destinationText.endsWith(File.separator)) {
            int dotIndex = destinationText.lastIndexOf(46);
            if (dotIndex != -1) {
                int pathSepIndex = destinationText.lastIndexOf(File.separator);
                if (pathSepIndex != -1 && dotIndex < pathSepIndex) {
                    destinationText = String.valueOf(destinationText) + idealSuffix;
                }
            } else {
                destinationText = String.valueOf(destinationText) + idealSuffix;
            }
        }
        return destinationText;
    }

    protected void handleDestinationBrowseButtonPressed() {
        String selectedFileName;
        FileDialog dialog = new FileDialog(this.getContainer().getShell(), 0x10002000);
        dialog.setFilterExtensions(this.getFileDialogFilterExtensions());
        dialog.setText(this.selectDestinationTitleMessage());
        String currentSourceString = this.getDestinationValue();
        int lastSeparatorIndex = currentSourceString.lastIndexOf(File.separator);
        if (lastSeparatorIndex != -1) {
            dialog.setFilterPath(currentSourceString.substring(0, lastSeparatorIndex));
        }
        if ((selectedFileName = dialog.open()) != null) {
            this.setErrorMessage(null);
            this.setDestinationValue(selectedFileName);
        }
    }

    protected void setDestinationValue(String value) {
        this.destinationNameField.setText(value);
    }

    protected boolean validateDestinationGroup() {
        String destinationValue = this.getDestinationValue();
        if (destinationValue.length() == 0) {
            this.setMessage(this.destinationEmptyMessage());
            return false;
        }
        String conflictingContainer = this.getConflictingContainerNameFor(destinationValue);
        if (conflictingContainer == null) {
            String threatenedContainer = this.getOverlappingProjectName(destinationValue);
            if (threatenedContainer == null) {
                this.setMessage(null);
            } else {
                this.setMessage(NLS.bind((String)DataTransferMessages.FileExport_damageWarning, (Object)threatenedContainer), 2);
            }
        } else {
            this.setErrorMessage(NLS.bind((String)DataTransferMessages.FileExport_conflictingContainer, (Object)conflictingContainer));
            this.giveFocusToDestination();
            return false;
        }
        return true;
    }

    protected String destinationEmptyMessage() {
        return DataTransferMessages.FileExport_destinationEmpty;
    }

    protected void saveWidgetValues() {
        this.internalSaveWidgetValues();
    }

    protected void internalSaveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] directoryNames = settings.getArray(this.getStoreDestinationNameId());
            if (directoryNames == null) {
                directoryNames = new String[]{};
            }
            directoryNames = this.addToHistory(directoryNames, this.getDestinationValue());
            settings.put(this.getStoreDestinationNameId(), directoryNames);
        }
    }

    protected void addDestinationItem(String value) {
        this.destinationNameField.add(value);
    }

    protected String getConflictingContainerNameFor(String targetDirectory) {
        String firstSegment;
        Path testPath = new Path(targetDirectory);
        IPath rootPath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        if (testPath.equals((Object)rootPath)) {
            return rootPath.lastSegment();
        }
        if (testPath.matchingFirstSegments(rootPath) == rootPath.segmentCount() && !Character.isLetterOrDigit((firstSegment = testPath.removeFirstSegments(rootPath.segmentCount()).segment(0)).charAt(0))) {
            return firstSegment;
        }
        return null;
    }

    private String getOverlappingProjectName(String targetDirectory) {
        Path testPath;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer[] containers = root.findContainersForLocation((IPath)(testPath = new Path(targetDirectory)));
        if (containers.length > 0) {
            return containers[0].getProject().getName();
        }
        return null;
    }
}

