/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.ui.wizards.AbstractFileExportWizardPage;
import org.tizen.common.rest.ui.wizards.AbstractOperation;
import org.tizen.common.rest.ui.wizards.SwaggerExportOperation;

public class SwaggerExportWizardPage
extends AbstractFileExportWizardPage {
    private static final String STORE_DESTINATION_NAMES_ID = "SwaggerExportWizardPage.STORE_DESTINATION_NAMES_ID";
    private Text textVersion;

    public SwaggerExportWizardPage(IStructuredSelection selection) {
        super("SwaggerExportWizardPage", selection, RestUIMessages.SwaggerExportWizardPage_title, RestUIMessages.SwaggerExportWizardPage_desc);
    }

    @Override
    protected void createOptionsGroup(Composite parent) {
        Font font = parent.getFont();
        Composite versionGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        versionGroup.setLayout((Layout)layout);
        versionGroup.setLayoutData((Object)new GridData(768));
        versionGroup.setFont(font);
        Label versionLabel = new Label(versionGroup, 0);
        versionLabel.setText(RestUIMessages.SwaggerExportWizardPage_version_label);
        versionLabel.setFont(font);
        this.textVersion = new Text(versionGroup, 2052);
        GridData data = new GridData();
        data.widthHint = 150;
        this.textVersion.setLayoutData((Object)data);
        this.textVersion.setText("1.0.0");
        this.textVersion.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SwaggerExportWizardPage.this.validateOptionsGroup();
            }
        });
    }

    protected boolean validateOptionsGroup() {
        boolean valid;
        boolean bl = valid = this.textVersion.getText().length() > 0;
        if (!valid) {
            this.setErrorMessage(RestUIMessages.SwaggerExportWizardPage_error_version_empty);
        }
        return valid;
    }

    @Override
    protected AbstractOperation createExportOperation(Application application, String desctinationValue) {
        return new SwaggerExportOperation(application, desctinationValue, this.textVersion.getText());
    }

    @Override
    protected String getDestinationLabel() {
        return RestUIMessages.SwaggerExportWizardPage_destinationLabel;
    }

    @Override
    protected String destinationEmptyMessage() {
        return RestUIMessages.SwaggerExportWizardPage_destinationEmpty;
    }

    @Override
    protected String selectDestinationTitleMessage() {
        return RestUIMessages.SwaggerExportWizardPage_selectDestinationTitle;
    }

    @Override
    protected String getOutputSuffix() {
        return "json";
    }

    @Override
    protected String[] getFileDialogFilterExtensions() {
        return new String[]{"*.json", "*.*"};
    }

    @Override
    protected String getStoreDestinationNameId() {
        return STORE_DESTINATION_NAMES_ID;
    }
}

