/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.wizards;

import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.http.entity.ContentType;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.swt.widgets.Display;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.constants.ISwaggerConstants;
import org.tizen.common.rest.model.RepositoryManager;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.Doc;
import org.tizen.common.rest.model.schema.Method;
import org.tizen.common.rest.model.schema.Param;
import org.tizen.common.rest.model.schema.ParamStyle;
import org.tizen.common.rest.model.schema.Representation;
import org.tizen.common.rest.model.schema.Request;
import org.tizen.common.rest.model.schema.Resource;
import org.tizen.common.rest.model.schema.Resources;
import org.tizen.common.rest.model.schema.Response;
import org.tizen.common.rest.ui.views.RestViewer;
import org.tizen.common.rest.ui.wizards.AbstractOperation;
import org.tizen.common.rest.util.OutputUtil;

public class SwaggerImportOperation
extends AbstractOperation
implements ISwaggerConstants {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private RestViewer viewer;
    private IProgressMonitor monitor;

    public SwaggerImportOperation(RestViewer viewer, String fileName) {
        super(fileName);
        this.viewer = viewer;
    }

    @Override
    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        block16: {
            this.monitor = monitor;
            int totalWork = -1;
            this.monitor.beginTask("Swagger file Import", totalWork);
            if (this.getFileName() != null) {
                String jsonString = null;
                File file = new File(this.getFileName());
                if (file != null && file.exists()) {
                    jsonString = this.getJsonString(file);
                    monitor.worked(1);
                } else {
                    try {
                        URL url = new URL(this.getFileName());
                        InputStream is = url.openStream();
                        jsonString = this.getJsonString(is);
                        monitor.worked(1);
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (MalformedURLException e) {
                        RestPlugin.log(e);
                    }
                    catch (IOException e) {
                        RestPlugin.log(e);
                    }
                }
                if (jsonString == null || jsonString.length() == 0) {
                    this.addError(RestUIMessages.SwaggerImportOperation_error_read, null);
                } else {
                    try {
                        String title;
                        final Map map = OutputUtil.fromJson(Map.class, jsonString);
                        if (map == null || map.size() == 0) {
                            throw new InvocationTargetException(new JsonSyntaxException(RestUIMessages.SwaggerImportOperation_error_parse));
                        }
                        final Application app = this.parseApplication(map);
                        if (app == null) {
                            throw new InvocationTargetException(new JsonSyntaxException(RestUIMessages.SwaggerImportOperation_error_no_root));
                        }
                        String mediaType = this.parseMediaType(map);
                        HashMap<String, List<Param>> paramMap = new HashMap<String, List<Param>>();
                        Resources resources = this.parseResources(map, app);
                        if (resources == null) break block16;
                        this.parseResource(paramMap, map, resources, mediaType);
                        if (this.viewer == null || app == null) break block16;
                        RepositoryManager rManager = RepositoryManager.getInstance();
                        boolean add = rManager.updateOrAddApplication(app, title = file.getName().split("\\.")[0]);
                        if (add) {
                            Display display = DebugUIPlugin.getStandardDisplay();
                            if (display != null && !display.isDisposed()) {
                                display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        SwaggerImportOperation.this.viewer.reloadTreeViewer();
                                        SwaggerImportOperation.this.saveAuthenticationSetting(app, map);
                                    }
                                });
                            }
                            break block16;
                        }
                        throw new JAXBException(RestUIMessages.SwaggerImportOperation_error_can_not_save);
                    }
                    catch (JAXBException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (JsonSyntaxException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            }
        }
        monitor.done();
    }

    private void saveAuthenticationSetting(Application app, Map map) {
        Map securityMap = (Map)map.get("securityDefinitions");
        if (securityMap == null || securityMap.size() == 0) {
            return;
        }
        Map accessCodeMap = (Map)securityMap.get("samiAccessCode");
        Map implicitMap = (Map)securityMap.get("samiImplicit");
        if (accessCodeMap != null && accessCodeMap.size() > 0) {
            String cfr_ignored_0 = (String)accessCodeMap.get("authorizationUrl");
            String cfr_ignored_1 = (String)accessCodeMap.get("tokenUrl");
        }
        if (implicitMap != null && implicitMap.size() > 0) {
            String cfr_ignored_2 = (String)implicitMap.get("authorizationUrl");
        }
    }

    private void parseResource(Map<String, List<Param>> paramMap, Map map, Resources resources, String mediaType) {
        Map pathMap = (Map)map.get("paths");
        if (pathMap != null && pathMap.size() > 0) {
            for (Map.Entry entry : pathMap.entrySet()) {
                String path = (String)entry.getKey();
                Resource res = new Resource(path);
                resources.addChild(res);
                Map methodMap = (Map)entry.getValue();
                if (methodMap == null || methodMap.size() <= 0) continue;
                this.parseMethod(paramMap, methodMap, res, mediaType);
            }
        }
    }

    private void parseMethod(Map<String, List<Param>> paramMap, Map<String, Map> methodMap, Resource res, String mediaType) {
        for (Map.Entry<String, Map> entry : methodMap.entrySet()) {
            String desc;
            String methodName = entry.getKey();
            Map methodProps = entry.getValue();
            if (methodProps == null || methodProps.size() == 0) continue;
            Method method = new Method();
            method.setName(methodName);
            String id = (String)methodProps.get("operationId");
            if (id != null && id.length() > 0) {
                method.setId(id);
            }
            if ((desc = (String)methodProps.get("description")) != null && desc.length() > 0) {
                method.setDescription(desc);
            }
            res.addChild(method);
            Request req = new Request();
            method.addChild(req);
            this.parseParam(paramMap, methodProps, req);
            this.parseResponse(methodProps, method, mediaType);
            this.monitor.worked(1);
        }
    }

    private void parseResponse(Map<String, Object> methodProps, Method method, String mediaType) {
        Map resPropMap;
        Map resMap = (Map)methodProps.get("responses");
        if (resMap != null && resMap.size() > 0 && (resPropMap = (Map)resMap.get("default")) != null && resPropMap.size() > 0) {
            Response response = new Response();
            response.setParent(method);
            method.getResponse().add(response);
            Representation rep = new Representation();
            rep.setMediaType(mediaType);
            rep.setParent(response);
            response.getRepresentation().add(rep);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void parseParam(Map<String, List<Param>> paramMap, Map<String, Object> methodProps, Request req) {
        block11: {
            paramList = (List)methodProps.get("parameters");
            if (paramList == null || paramList.size() <= 0) break block11;
            i = 0;
            while (paramList != null && i < paramList.size()) {
                block12: {
                    block14: {
                        block13: {
                            paramPropMap = (Map)paramList.get(i);
                            if (paramPropMap == null || paramPropMap.size() == 0) break block12;
                            in = (String)paramPropMap.get("in");
                            pStyle = ParamStyle.QUERY;
                            if (!"header".equals(in)) break block13;
                            pStyle = ParamStyle.HEADER;
                            ** GOTO lbl-1000
                        }
                        if (!"path".equals(in)) break block14;
                        pStyle = ParamStyle.TEMPLATE;
                        ** GOTO lbl-1000
                    }
                    if ("body".equals(in)) {
                        pStyle = ParamStyle.PLAIN;
                    } else lbl-1000:
                    // 3 sources

                    {
                        schemaMap = (Map)paramPropMap.get("schema");
                        if (schemaMap != null && schemaMap.size() > 0) {
                            ref = (String)schemaMap.get("$ref");
                            pList = paramMap.get(ref);
                            if (pList != null && pList.size() > 0) {
                                j = 0;
                                while (j < pList.size()) {
                                    refParam = pList.get(j);
                                    refId = refParam.getId();
                                    newParam = new Param();
                                    newParam.setHref("#" + refId);
                                    newParam.setStyle(pStyle);
                                    req.addChild(newParam);
                                    ++j;
                                }
                            }
                        } else {
                            name = (String)paramPropMap.get("name");
                            if (name != null && name.length() != 0) {
                                type = (String)paramPropMap.get("type");
                                required = (Boolean)paramPropMap.get("required");
                                desc = (String)paramPropMap.get("description");
                                newParam = new Param();
                                newParam.setName(name);
                                newParam.setStyle(pStyle);
                                if (type == null || type.length() == 0) {
                                    type = "string";
                                }
                                newParam.setType(new QName("http://wadl.dev.java.net/2009/02", type));
                                if (required) {
                                    newParam.setRequired(required);
                                }
                                if (desc != null && desc.length() > 0) {
                                    doc = new Doc(desc);
                                    doc.setParent(newParam);
                                    newParam.getDoc().add(doc);
                                }
                                req.addChild(newParam);
                            }
                        }
                    }
                }
                ++i;
            }
        }
    }

    private Resources parseResources(Map map, Application app) {
        List schemes = (List)map.get("schemes");
        String scheme = (String)schemes.get(0);
        String host = (String)map.get("host");
        String basePath = (String)map.get("basePath");
        Resources resources = new Resources(String.valueOf(scheme) + "://" + host + basePath);
        app.addChild(resources);
        return resources;
    }

    private Map<String, List<Param>> parseParamRefModel(Map map, Application app) {
        HashMap<String, List<Param>> paramMap = new HashMap<String, List<Param>>();
        Map defMap = (Map)map.get("definitions");
        for (Map.Entry entry : defMap.entrySet()) {
            String paramSetKey = (String)entry.getKey();
            Map values = (Map)entry.getValue();
            ArrayList<Param> buf = new ArrayList<Param>();
            Map params = (Map)values.get("properties");
            List requiredList = (List)values.get("required");
            for (Map.Entry e : params.entrySet()) {
                Param p = new Param();
                String key = (String)e.getKey();
                p.setName(key);
                p.setId(String.valueOf(paramSetKey) + "." + key);
                String type = (String)((Map)e.getValue()).get("type");
                if (type != null && type.length() > 0) {
                    p.setType(new QName("http://wadl.dev.java.net/2009/02", type));
                } else {
                    String ref = (String)((Map)e.getValue()).get("$ref");
                    if (ref != null && ref.length() > 0) {
                        p.setHref("#" + ref);
                    }
                }
                if (requiredList != null && requiredList.contains(key)) {
                    p.setRequired(true);
                }
                buf.add(p);
                app.addChild(p);
            }
            paramMap.put(paramSetKey, buf);
        }
        return paramMap;
    }

    private String parseMediaType(Map map) {
        String mediaType = ContentType.APPLICATION_JSON.getMimeType();
        List produces = (List)map.get("produces");
        if (produces != null && produces.size() > 0) {
            mediaType = (String)produces.get(0);
        }
        return mediaType;
    }

    private Application parseApplication(Map map) {
        Map infoMap = (Map)map.get("info");
        String title = (String)infoMap.get("title");
        return new Application(title);
    }

    private String getJsonString(InputStream is) {
        StringBuffer buf;
        block15: {
            BufferedReader reader = null;
            String line = null;
            buf = new StringBuffer();
            try {
                try {
                    reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    while ((line = reader.readLine()) != null) {
                        buf.append(String.valueOf(line) + LINE_SEPARATOR);
                    }
                }
                catch (IOException e) {
                    RestPlugin.log(e);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buf.toString();
    }

    private String getJsonString(File file) {
        String result;
        block14: {
            result = null;
            FileInputStream stream = null;
            try {
                try {
                    stream = new FileInputStream(file);
                    result = this.getJsonString(stream);
                }
                catch (FileNotFoundException e) {
                    RestPlugin.log(e);
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }
}

