/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.preferenceWindow;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.flatButton.FlatButton;
import org.mihalis.opal.preferenceWindow.PWTab;
import org.mihalis.opal.utils.SWTGraphicUtil;

class PWTabContainer
extends Composite {
    private final List<PWTab> tabs = new ArrayList<PWTab>();
    private Composite container;
    private Image oldButtonContainerImage;
    private final List<FlatButton> buttons;
    private Composite buttonContainer;

    PWTabContainer(Composite parent, int style, List<PWTab> tabs) {
        super(parent, style);
        this.tabs.addAll(tabs);
        this.buttons = new ArrayList<FlatButton>();
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        this.setLayout((Layout)gridLayout);
    }

    void build() {
        this.build(null);
    }

    void build(Color selectedTabColor) {
        this.createButtonsContainer();
        this.createButtons(selectedTabColor);
        this.createContentContainer();
        this.select(0);
    }

    private void createButtonsContainer() {
        this.createContainer();
        this.createButtonsContainerBackground();
    }

    private void createContainer() {
        this.buttonContainer = new Composite((Composite)this, 0);
        GridData buttonContainerGridData = new GridData(4, 4, true, false, 2, 1);
        this.buttonContainer.setLayoutData((Object)buttonContainerGridData);
        this.buttonContainer.setBackground(this.getDisplay().getSystemColor(1));
        GridLayout gridLayout = new GridLayout(this.tabs.size(), false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginBottom = 2;
        this.buttonContainer.setLayout((Layout)gridLayout);
    }

    private void createButtonsContainerBackground() {
        this.buttonContainer.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle rect = PWTabContainer.this.buttonContainer.getClientArea();
                Image image = new Image((Device)PWTabContainer.this.getDisplay(), Math.max(1, rect.width), Math.max(1, rect.height));
                GC gc = new GC((Drawable)image);
                Color grey = new Color((Device)PWTabContainer.this.getDisplay(), 204, 204, 204);
                gc.setForeground(grey);
                gc.drawLine(0, rect.height - 1, rect.width, rect.height - 1);
                grey.dispose();
                gc.dispose();
                PWTabContainer.this.buttonContainer.setBackgroundImage(image);
                if (PWTabContainer.this.oldButtonContainerImage != null) {
                    PWTabContainer.this.oldButtonContainerImage.dispose();
                }
                PWTabContainer.this.oldButtonContainerImage = image;
            }
        });
        SWTGraphicUtil.dispose((Control)this.buttonContainer, (Resource)this.oldButtonContainerImage);
    }

    private void createButtons(Color selectedTabColor) {
        int i = 0;
        while (i < this.tabs.size()) {
            PWTab tab = this.tabs.get(i);
            FlatButton button = new FlatButton(this.buttonContainer, 0);
            button.setText(tab.getText());
            button.setImage(tab.getImage());
            if (selectedTabColor != null) {
                button.setSelectedColor(selectedTabColor);
            }
            SWTGraphicUtil.dispose((Control)button, (Resource)tab.getImage());
            GridData gd = i == this.tabs.size() - 1 ? new GridData(1, 1, true, false) : new GridData(1, 1, false, false);
            if (i == 0) {
                gd.horizontalIndent = 5;
            }
            gd.widthHint = 75;
            button.setLayoutData(gd);
            final int index = i++;
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PWTabContainer.this.select(index);
                }
            });
            this.buttons.add(button);
        }
    }

    private void select(int index) {
        Control[] controlArray = this.container.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        this.tabs.get(index).build(this.container);
        this.container.layout();
        int i = 0;
        while (i < this.buttons.size()) {
            this.buttons.get(i).setSelection(i == index);
            ++i;
        }
    }

    private void createContentContainer() {
        this.container = new Composite((Composite)this, 0);
        GridData tempContainer = new GridData(4, 4, true, true, 2, 1);
        int defaultSize = 350;
        int notebookSize = 280;
        tempContainer.heightHint = defaultSize;
        Rectangle bounds = Display.getCurrent().getBounds();
        if (bounds.height <= 768 + defaultSize - notebookSize) {
            tempContainer.heightHint = notebookSize;
        }
        this.container.setLayoutData((Object)tempContainer);
    }

    public Composite getContainer() {
        return this.container;
    }
}

