/*
 * Decompiled with CFR 0.152.
 */
package zipeditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.StatusLineLayoutData;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.RetargetAction;
import org.eclipse.ui.part.EditorActionBarContributor;
import zipeditor.Messages;
import zipeditor.ZipEditorPlugin;

public class ZipEditorActionBarContributor
extends EditorActionBarContributor {
    private Composite errorStatusControl;
    private Label errorLabel;
    private Map errors = new HashMap();
    private IEditorPart activeEditor;
    private RetargetAction selectPattern;
    private RetargetAction reverseSelection;

    public void contributeToStatusLine(IStatusLineManager statusLineManager) {
        statusLineManager.add((IContributionItem)new ErrorStatus());
    }

    public void contributeToMenu(IMenuManager menuManager) {
        this.initActions();
        IMenuManager menu = menuManager.findMenuUsingPath("edit");
        if (menu != null) {
            menu.insertAfter(ActionFactory.SELECT_ALL.getId(), (IAction)this.selectPattern);
            menu.insertAfter("zipeditor.command.selectPattern", (IAction)this.reverseSelection);
        }
    }

    private void initActions() {
        if (this.selectPattern == null) {
            this.selectPattern = new RetargetAction("zipeditor.command.selectPattern", Messages.getString("ZipEditorActionBarContributor.1"));
            this.selectPattern.setActionDefinitionId("zipeditor.command.selectPattern");
            this.getPage().addPartListener((IPartListener)this.selectPattern);
        }
        if (this.reverseSelection == null) {
            this.reverseSelection = new RetargetAction("zipeditor.command.reverseSelection", Messages.getString("ZipEditorActionBarContributor.2"));
            this.reverseSelection.setActionDefinitionId("zipeditor.command.reverseSelection");
            this.getPage().addPartListener((IPartListener)this.reverseSelection);
        }
    }

    private void showErrorDetails() {
        if (this.getErrors().size() == 0) {
            return;
        }
        IStatus status = (IStatus)this.getErrors().remove(0);
        ZipEditorPlugin.showErrorDialog(this.getPage().getWorkbenchWindow().getShell(), status.getMessage(), status.getException(), false);
        this.showCurrentError();
    }

    private void clearErrors() {
        this.getErrors().clear();
        this.errorStatusControl.setVisible(false);
    }

    private boolean hasErrors() {
        return this.getErrors().size() > 0;
    }

    private void showCurrentError() {
        if (this.errorStatusControl == null || this.errorStatusControl.isDisposed()) {
            return;
        }
        boolean hasErrors = this.hasErrors();
        this.errorStatusControl.setVisible(hasErrors);
        if (hasErrors) {
            List errorList = this.getErrors();
            this.errorLabel.setText("[" + errorList.size() + "] " + ((IStatus)errorList.get(0)).getMessage());
        }
    }

    private List getErrors() {
        ArrayList errorList = (ArrayList)this.errors.get(this.activeEditor);
        if (errorList == null) {
            errorList = new ArrayList();
            this.errors.put(this.activeEditor, errorList);
        }
        return errorList;
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        this.activeEditor = targetEditor;
        this.showCurrentError();
    }

    public void dispose() {
        this.activeEditor = null;
        this.errors.clear();
        this.getPage().removePartListener((IPartListener)this.selectPattern);
    }

    public void reportError(IEditorPart editor, IStatus message) {
        this.activeEditor = editor;
        this.getErrors().add(message);
        this.getPage().getWorkbenchWindow().getShell().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ZipEditorActionBarContributor.this.showCurrentError();
            }
        });
    }

    private class ErrorStatus
    extends ControlContribution {
        private ErrorStatus() {
            super("zipeditor.ErrorStatusContribution");
        }

        protected Control createControl(Composite parent) {
            Composite control = new Composite(parent, 0);
            StatusLineLayoutData data = new StatusLineLayoutData();
            data.widthHint = Integer.MAX_VALUE;
            control.setLayoutData((Object)data);
            GridLayout layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            control.setLayout((Layout)layout);
            ZipEditorActionBarContributor.this.errorLabel = new Label(control, 16384);
            ZipEditorActionBarContributor.this.errorLabel.setLayoutData((Object)new GridData(768));
            ZipEditorActionBarContributor.this.errorLabel.setBackground(parent.getBackground());
            ZipEditorActionBarContributor.this.errorLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    ZipEditorActionBarContributor.this.showErrorDetails();
                }
            });
            ZipEditorActionBarContributor.this.errorLabel.setForeground(JFaceColors.getErrorText((Display)parent.getDisplay()));
            ToolBar bar = new ToolBar(control, 0x800100);
            ToolItem delete = new ToolItem(bar, 0x800008);
            delete.setImage(ZipEditorPlugin.getImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE")));
            delete.setToolTipText(Messages.getString("ZipEditorActionBarContributor.0"));
            delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ZipEditorActionBarContributor.this.clearErrors();
                }
            });
            ZipEditorActionBarContributor.this.errorStatusControl = control;
            ZipEditorActionBarContributor.this.showCurrentError();
            return control;
        }
    }
}

