/*
 * Decompiled with CFR 0.152.
 */
package zipeditor;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import zipeditor.MultiElementPropertyPage;
import zipeditor.NodePropertyPage;
import zipeditor.model.Node;
import zipeditor.model.ZipNode;
import zipeditor.model.ZipNodeProperty;

public class ZipNodePropertyPage
extends NodePropertyPage
implements IWorkbenchPropertyPage {
    private Text fAttributes;
    private Text fPackedSize;
    private Text fRatio;
    private Text fCrc;
    private Text fComment;

    protected Control createContents(Composite parent) {
        Composite control = (Composite)this.createPropertiesSection(parent);
        this.createLabel(control, ZipNodeProperty.PPACKED_SIZE.toString(), 1);
        this.fPackedSize = this.createText(control, 30, 1, false);
        this.setFieldText(this.fPackedSize, new NodePropertyPage.NodePropertyAccessor(this){

            @Override
            public Object getSinglePropertyValue(Node node) {
                return new Long(((ZipNode)node).getCompressedSize());
            }
        }, true);
        this.createLabel(control, ZipNodeProperty.PRATIO.toString(), 1);
        this.fRatio = this.createText(control, 30, 1, false);
        this.setFieldText(this.fRatio, new MultiElementPropertyPage.PropertyAccessor(){

            @Override
            public Object getPropertyValue(Object object) {
                return String.valueOf(ZipNodePropertyPage.this.formatLong(Math.max(Math.round(((ZipNode)((Object)object)).getRatio()), 0L))) + "%";
            }
        });
        this.createLabel(control, ZipNodeProperty.PCRC.toString(), 1);
        this.fCrc = this.createText(control, 30, 1, false);
        this.setFieldText(this.fCrc, new MultiElementPropertyPage.PropertyAccessor(){

            @Override
            public Object getPropertyValue(Object object) {
                return Long.toHexString(((ZipNode)((Object)object)).getCrc()).toUpperCase();
            }
        });
        this.createLabel(control, ZipNodeProperty.PATTR.toString(), 1);
        this.fAttributes = this.createText(control, 30, 1, false);
        this.setFieldText(this.fAttributes, new MultiElementPropertyPage.PropertyAccessor(){

            @Override
            public Object getPropertyValue(Object object) {
                return new String(((ZipNode)((Object)object)).getExtra());
            }
        });
        this.createLabel(control, ZipNodeProperty.PCOMMENT.toString(), 1);
        this.fComment = this.createText(control, 30, 1, true);
        this.setFieldText(this.fComment, new MultiElementPropertyPage.MultiplePropertyAccessor(ZipNode.class).getAccessor("comment"));
        this.applyDialogFont(control);
        return control;
    }

    @Override
    public boolean performOk() {
        boolean ok = super.performOk();
        if (!ok) {
            return false;
        }
        Node[] nodes = this.getNodes();
        String comment = this.fComment.getText();
        int i = 0;
        while (i < nodes.length) {
            if (!this.nonEqualStringLabel.equals(comment)) {
                ((ZipNode)nodes[i]).setComment(comment.length() > 0 ? comment : null);
            }
            ++i;
        }
        return true;
    }
}

