/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.logview.resources;

import java.io.IOException;
import java.io.InputStream;
import javafx.application.Platform;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.logview.resources.ImageKind;
import org.tizen.common.connection.logview.resources.ResourceLoader;
import org.tizen.common.connection.logview.resources.ResourceRegistry;

final class ImageViewRegistry
extends ResourceRegistry<ImageKind, ImageView> {
    private final Platform platform;
    private Logger logger = LoggerFactory.getLogger(ImageViewRegistry.class);

    ImageViewRegistry(Platform platform) {
        this.platform = platform;
    }

    @Override
    ImageView getInternal(ImageKind kind) {
        Image i = null;
        InputStream is = ResourceLoader.load(String.valueOf(kind.name) + "." + (Object)((Object)kind.type), this.platform);
        if (is != null) {
            i = new Image(is);
            try {
                is.close();
            }
            catch (IOException e) {
                this.logger.info(e.getMessage());
            }
        }
        return new ImageView(i);
    }

    @Override
    void dispose() {
    }
}

