/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.preference;

import java.io.File;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.connection.preference.PreferenceMessages;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.OSChecker;
import org.tizen.common.util.SWTUtil;

public class TizenConnectionExplorerPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String EMULATOR_PATH = InstallPathConfig.getEmulatorPath();
    private static final String EMULATOR_BATCH = "bin" + File.separatorChar + "emulator-manager.exe";
    private static final String EMULATOR_BINARY = "bin" + File.separatorChar + "emulator-manager";
    public static final String KEY_PUSHPULL_TIMEOUT = "pushpull_timeout";
    public static final String KEY_EMULATOR_MANAGER_PATH = "emulator_manager_path";
    public static final String KEY_TERMINAL_PATH = "terminal_path";
    public static final int VALUE_TRANSFER_TIMEOUT_DEFAULT = 30000;
    public static final String VALUE_EMULATOR_MANAGER_PATH_DEFAULT = TizenConnectionExplorerPreferencePage.getEmulatorManagerDefaultPath();
    public static final String VALUE_TERMINAL_PATH_DEFAULT = TizenConnectionExplorerPreferencePage.getTerminalDefaultPath();
    public static final String OPEN_SHELL_SCRIPT_PATH_MAC = "/emulator/bin/sdbscript";
    private static final String OPEN_SHELL_SCRIPT_FILE_MAC = "sdbscript";

    public TizenConnectionExplorerPreferencePage() {
        this.setPreferenceStore(ConnectionPlugin.getDefault().getPreferenceStore());
        this.setDescription(PreferenceMessages.CONNECTION_EXPLORER_DESCRIPTION);
    }

    public void init(IWorkbench workbench) {
    }

    protected void createFieldEditors() {
        Composite composite = this.getFieldEditorParent();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        SWTUtil.createSpacer((Composite)composite, (int)1);
        this.createPathSettingPreferences(composite);
        SWTUtil.createSpacer((Composite)composite, (int)1);
        this.createPushPullTimeoutPreferences(composite);
        SWTUtil.createSpacer((Composite)composite, (int)1);
        this.createOpenShellTerminalPreferences(composite);
    }

    private void createPathSettingPreferences(Composite parent) {
        Group comp = SWTUtil.createGroup((Composite)parent, (String)PreferenceMessages.CONNECTION_EXPLORER_GROUP_EMULATOR_MANAGER, (int)1);
        Composite formatComposite = SWTUtil.createCompositeEx((Composite)comp, (int)1, (int)768);
        StringFieldEditor fileField = new StringFieldEditor(KEY_EMULATOR_MANAGER_PATH, PreferenceMessages.CONNECTION_EXPLORER_LABEL_LOCATION, formatComposite);
        fileField.getTextControl(formatComposite).setEditable(false);
        this.addField((FieldEditor)fileField);
    }

    private void createPushPullTimeoutPreferences(Composite parent) {
        Group comp = SWTUtil.createGroup((Composite)parent, (String)PreferenceMessages.CONNECTION_EXPLORER_GROUP_TIMEOUT, (int)1);
        Composite formatComposite = SWTUtil.createCompositeEx((Composite)comp, (int)2, (int)768);
        IntegerFieldEditor intField = new IntegerFieldEditor(KEY_PUSHPULL_TIMEOUT, PreferenceMessages.CONNECTION_EXPLORER_LABEL_TIMEOUT, formatComposite);
        intField.setValidRange(0, Integer.MAX_VALUE);
        intField.getTextControl(formatComposite).setToolTipText(PreferenceMessages.CONNECTION_EXPLORER_TIMEOUT_CAUTION);
        Label nullLabel = new Label(formatComposite, 0);
        nullLabel.setText("");
        Label cautionLabel = new Label(formatComposite, 0);
        cautionLabel.setText(PreferenceMessages.CONNECTION_EXPLORER_TIMEOUT_CAUTION);
        this.addField((FieldEditor)intField);
    }

    private void createOpenShellTerminalPreferences(Composite parent) {
        Group comp = SWTUtil.createGroup((Composite)parent, (String)PreferenceMessages.CONNECTION_EXPLORER_GROUP_TERMINAL, (int)1);
        Composite formatComposite = SWTUtil.createCompositeEx((Composite)comp, (int)1, (int)768);
        StringFieldEditor fileField = new StringFieldEditor(KEY_TERMINAL_PATH, PreferenceMessages.CONNECTION_EXPLORER_GROUP_TERMINAL_PATH, formatComposite);
        this.addField((FieldEditor)fileField);
    }

    private static String getEmulatorManagerDefaultPath() {
        String exePath = null;
        int osType = ConnectionPlugin.getDefault().os;
        int linuxType = 0;
        exePath = osType == linuxType ? String.valueOf(EMULATOR_PATH) + File.separatorChar + EMULATOR_BINARY : String.valueOf(EMULATOR_PATH) + File.separatorChar + EMULATOR_BATCH;
        return exePath;
    }

    private static String getTerminalDefaultPath() {
        String termPath = null;
        termPath = OSChecker.isWindows() ? String.valueOf(System.getenv("ComSpec")) + " /c start" : (OSChecker.isMAC() ? String.valueOf(InstallPathConfig.getEmulatorPath()) + File.separatorChar + "bin" + File.separatorChar + OPEN_SHELL_SCRIPT_FILE_MAC : "/usr/bin/gnome-terminal -x");
        return termPath;
    }
}

