/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.properties;

import java.io.IOException;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.sdblib.service.FileEntryType;

public class ConnectionExplorerInfoPropertyPages
extends PropertyPage
implements IWorkbenchPropertyPage {
    private final Logger logger = LoggerFactory.getLogger(ConnectionExplorerInfoPropertyPages.class);
    private static final String NAME_TITLE = "Name:";
    private static final String DUID_TITLE = "DUID (Device Unique IDentifier):";
    private static final String PATH_TITLE = "Path:";
    private static final String TYPE_TITLE = "Type:";
    private static final String SIZE_TITLE = "Size:";
    private static final String LAST_TITLE = "Last Modified:";

    private void addRtSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText(NAME_TITLE);
        FileEntry f = (FileEntry)this.getElement().getAdapter(FileEntry.class);
        Label pathValueText = new Label(composite, 0);
        pathValueText.setText(f.getName());
    }

    private void addDUIDSection(Composite parent) {
        FileEntry f = (FileEntry)this.getElement().getAdapter(FileEntry.class);
        IDevice device = f.getDevice();
        try {
            String duid = device.getDUID();
            if (duid == null) {
                return;
            }
            Composite composite = this.createDefaultComposite(parent);
            Label duidLabel = new Label(composite, 0);
            duidLabel.setText(DUID_TITLE);
            Text duidValueText = new Text(composite, 8);
            duidValueText.setText(duid);
            duidValueText.setBackground(duidValueText.getDisplay().getSystemColor(22));
        }
        catch (TimeoutException e) {
            this.logger.error("Failed to get DUID : no response from device", (Object)e.getMessage());
        }
        catch (SdbCommandRejectedException e) {
            this.logger.error("Failed to get DUID : rejected to get DUID ", (Object)e.getMessage());
        }
        catch (IOException e) {
            this.logger.error("Failed to get DUID", (Object)e.getMessage());
        }
    }

    private void addFirstSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText(PATH_TITLE);
        FileEntry f = (FileEntry)this.getElement().getAdapter(FileEntry.class);
        Label pathValueText = new Label(composite, 0);
        pathValueText.setText(f.getFullPath());
    }

    private void addSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        separator.setLayoutData((Object)gridData);
    }

    private void addSecondSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText(TYPE_TITLE);
        FileEntry f = (FileEntry)this.getElement().getAdapter(FileEntry.class);
        Label pathValueText = new Label(composite, 0);
        pathValueText.setText(f.getType().toString());
    }

    private void addThirdSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText(SIZE_TITLE);
        FileEntry f = (FileEntry)this.getElement().getAdapter(FileEntry.class);
        Label pathValueText = new Label(composite, 0);
        pathValueText.setText(String.valueOf(f.getSize()) + " bytes");
    }

    private void addFourthSection(Composite parent) {
        Composite composite = this.createDefaultComposite(parent);
        Label pathLabel = new Label(composite, 0);
        pathLabel.setText(LAST_TITLE);
        FileEntry f = (FileEntry)this.getElement().getAdapter(FileEntry.class);
        Label pathValueText = new Label(composite, 0);
        pathValueText.setText(String.valueOf(f.getDate()) + " " + f.getTime());
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(2);
        data.grabExcessHorizontalSpace = true;
        composite.setLayoutData((Object)data);
        FileEntry f = (FileEntry)this.getElement().getAdapter(FileEntry.class);
        if (f.getType() == FileEntryType.RootDevice || f.getType() == FileEntryType.RootEmulator) {
            this.addRtSection(composite);
            this.addDUIDSection(composite);
        } else {
            this.addFirstSection(composite);
            this.addSecondSection(composite);
            this.addThirdSection(composite);
            this.addFourthSection(composite);
            this.addSeparator(composite);
        }
        return composite;
    }

    private Composite createDefaultComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }

    public boolean performOk() {
        return true;
    }
}

