/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.tizen.common.lv.ITizenLocalizer;
import org.tizen.common.lv.model.LVLocaleVO;

public class LVLocaleManager {
    private static Map<Class<? extends ITizenLocalizer>, Map<String, LVLocaleVO>> supportLocaleMap = new HashMap<Class<? extends ITizenLocalizer>, Map<String, LVLocaleVO>>();
    public static LVLocaleVO defaultLocale = new LVLocaleVO();
    private IProject project;
    private List<LVLocaleVO> targetLocaleList = new ArrayList<LVLocaleVO>();

    public LVLocaleManager() {
    }

    public LVLocaleManager(IProject project) {
        this();
        this.project = project;
        this.targetLocaleList.add(defaultLocale);
    }

    public IProject getProject() {
        return this.project;
    }

    public List<LVLocaleVO> getTargetLocaleList() {
        return this.targetLocaleList;
    }

    public static Map<String, LVLocaleVO> getSupportLocalesMap(ITizenLocalizer localizer) {
        if (!supportLocaleMap.containsKey(localizer.getClass())) {
            LinkedHashMap<String, LVLocaleVO> supportLocaleMapWithTag = new LinkedHashMap<String, LVLocaleVO>();
            String[][] langTags = localizer.getSupportLocales();
            int i = 0;
            while (i < langTags.length) {
                supportLocaleMapWithTag.put(langTags[i][0], new LVLocaleVO(langTags[i][0], langTags[i][1], langTags[i][2]));
                ++i;
            }
            supportLocaleMap.put(localizer.getClass(), supportLocaleMapWithTag);
        }
        return supportLocaleMap.get(localizer.getClass());
    }

    public void add(LVLocaleVO[] newLocales) {
        LVLocaleVO[] lVLocaleVOArray = newLocales;
        int n = newLocales.length;
        int n2 = 0;
        while (n2 < n) {
            LVLocaleVO locale = lVLocaleVOArray[n2];
            this.targetLocaleList.add(locale);
            ++n2;
        }
    }

    public void remove(LVLocaleVO[] oldLocales) {
        LVLocaleVO[] lVLocaleVOArray = oldLocales;
        int n = oldLocales.length;
        int n2 = 0;
        while (n2 < n) {
            LVLocaleVO locale = lVLocaleVOArray[n2];
            Iterator<LVLocaleVO> iter = this.targetLocaleList.iterator();
            while (iter.hasNext()) {
                LVLocaleVO vo = iter.next();
                if (!vo.equals(locale)) continue;
                iter.remove();
            }
            ++n2;
        }
    }

    public List<String> getTargetLocaleLanguageTagList() {
        ArrayList<String> languageTagList = new ArrayList<String>();
        for (LVLocaleVO locale : this.targetLocaleList) {
            languageTagList.add(locale.getLanguageTag());
        }
        return languageTagList;
    }

    public void clear() {
        this.project = null;
        this.targetLocaleList.clear();
    }
}

