/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.lv.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.lv.ui.resource.TizenWebLocaleUtil;

public class LVResourceManager {
    private final Logger logger = LoggerFactory.getLogger(LVResourceManager.class);
    private boolean isDirty;
    private IProject project = null;
    private List<String> defaultChildFolderPathList = new ArrayList<String>();
    private Map<String, List<String>> defaultResourceMap = new HashMap<String, List<String>>();
    private List<IResource> localeFolderList = new ArrayList<IResource>();

    public LVResourceManager() {
    }

    public LVResourceManager(IProject project) {
        this.setProject(project);
    }

    private void buildData() {
        this.clearData();
        try {
            this.makeLocaleFolderList();
            this.makeDefaultChildFolderList();
            this.makeDefaultResourceMap();
        }
        catch (CoreException e) {
            this.clearData();
            this.logger.debug(e.getMessage());
        }
        this.isDirty = true;
    }

    private void clearData() {
        this.defaultChildFolderPathList.clear();
        this.defaultResourceMap.clear();
        this.localeFolderList.clear();
    }

    public void setProject(IProject project) {
        this.project = project;
        this.buildData();
    }

    public List<IResource> getLocaleFolderList() {
        return this.localeFolderList;
    }

    public Map<String, List<String>> getDefaultResourceMap() {
        return this.defaultResourceMap;
    }

    public List<String> getDefaultChildFolderPathList() {
        return this.defaultChildFolderPathList;
    }

    public void updateDelta(IResourceDelta delta) {
        if (this.project == null || delta.findMember(this.project.getFullPath()) == null) {
            return;
        }
        this.buildData();
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    private void makeLocaleFolderList() throws CoreException {
        IFolder localeRootFolder = this.project.getFolder("locales");
        if (!localeRootFolder.exists()) {
            return;
        }
        localeRootFolder.accept(new IResourceVisitor((IResource)localeRootFolder){
            private final /* synthetic */ IResource val$localeRootFolder;
            {
                this.val$localeRootFolder = iResource;
            }

            public boolean visit(IResource resource) throws CoreException {
                if (this.val$localeRootFolder.equals((Object)resource) || resource.getType() != 2) {
                    return true;
                }
                if (TizenWebLocaleUtil.isSupportedLocale(resource.getName())) {
                    LVResourceManager.this.localeFolderList.add(resource);
                    return false;
                }
                return true;
            }
        }, 1, false);
    }

    private void makeDefaultChildFolderList() throws CoreException {
        this.project.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                String path;
                if (resource.getType() == 2 && TizenWebLocaleUtil.isLocalizableFolder(path = resource.getProjectRelativePath().toOSString())) {
                    LVResourceManager.this.defaultChildFolderPathList.add(path);
                }
                return true;
            }
        }, 1, false);
    }

    private void makeDefaultResourceMap() throws CoreException {
        this.project.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                LVResourceManager.this.addFileResource("", resource);
                return true;
            }
        }, 1, false);
        for (final String defaultChildFolderPath : this.defaultChildFolderPathList) {
            IFolder folder = this.project.getFolder(defaultChildFolderPath);
            if (!folder.exists()) continue;
            folder.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    LVResourceManager.this.addFileResource(defaultChildFolderPath, resource);
                    return true;
                }
            });
        }
    }

    private void addFileResource(String key, IResource resource) {
        if (resource.getType() == 1 && !resource.isHidden()) {
            String extension;
            String name;
            List<String> resourceList = this.defaultResourceMap.get(key);
            if (resourceList == null) {
                resourceList = new ArrayList<String>();
                this.defaultResourceMap.put(key, resourceList);
            }
            if (TizenWebLocaleUtil.isLocalizableFile(name = resource.getName(), extension = resource.getFileExtension())) {
                resourceList.add(resource.getProjectRelativePath().toOSString());
            }
        }
    }

    public void clear() {
    }
}

