/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.IOException;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Properties;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.file.FileRepository;
import org.eclipse.jgit.internal.storage.file.GC;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GarbageCollectCommand
extends GitCommand<Properties> {
    private ProgressMonitor monitor;
    private Date expire;

    protected GarbageCollectCommand(Repository repo) {
        super(repo);
        if (!(repo instanceof FileRepository)) {
            throw new UnsupportedOperationException(MessageFormat.format(JGitText.get().unsupportedGC, repo.getClass().toString()));
        }
    }

    public GarbageCollectCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public GarbageCollectCommand setExpire(Date expire) {
        this.expire = expire;
        return this;
    }

    @Override
    public Properties call() throws GitAPIException {
        this.checkCallable();
        GC gc = new GC((FileRepository)this.repo);
        gc.setProgressMonitor(this.monitor);
        if (this.expire != null) {
            gc.setExpire(this.expire);
        }
        try {
            gc.gc();
            return GarbageCollectCommand.toProperties(gc.getStatistics());
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().gcFailed, e);
        }
        catch (ParseException e) {
            throw new JGitInternalException(JGitText.get().gcFailed, e);
        }
    }

    public Properties getStatistics() throws GitAPIException {
        try {
            GC gc = new GC((FileRepository)this.repo);
            return GarbageCollectCommand.toProperties(gc.getStatistics());
        }
        catch (IOException e) {
            throw new JGitInternalException(JGitText.get().couldNotGetRepoStatistics, e);
        }
    }

    private static Properties toProperties(GC.RepoStatistics stats) {
        Properties p = new Properties();
        p.put("numberOfLooseObjects", (Object)stats.numberOfLooseObjects);
        p.put("numberOfLooseRefs", (Object)stats.numberOfLooseRefs);
        p.put("numberOfPackedObjects", (Object)stats.numberOfPackedObjects);
        p.put("numberOfPackedRefs", (Object)stats.numberOfPackedRefs);
        p.put("numberOfPackFiles", (Object)stats.numberOfPackFiles);
        p.put("sizeOfLooseObjects", (Object)stats.sizeOfLooseObjects);
        p.put("sizeOfPackedObjects", (Object)stats.sizeOfPackedObjects);
        return p;
    }
}

