/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.pgm;

import java.util.Iterator;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ReflogCommand;
import org.eclipse.jgit.lib.ReflogEntry;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.pgm.Command;
import org.eclipse.jgit.pgm.TextBuiltin;
import org.kohsuke.args4j.Argument;

@Command(common=true, usage="usage_manageReflogInformation")
class Reflog
extends TextBuiltin {
    @Argument(metaVar="metaVar_ref")
    private String ref;

    Reflog() {
    }

    protected void run() throws Exception {
        ReflogCommand cmd = new Git(this.db).reflog();
        if (this.ref != null) {
            cmd.setRef(this.ref);
        }
        Object entries = cmd.call();
        int i = 0;
        Iterator i$ = entries.iterator();
        while (i$.hasNext()) {
            ReflogEntry entry = (ReflogEntry)i$.next();
            this.outw.println(this.toString(entry, i++));
        }
    }

    private String toString(ReflogEntry entry, int i) {
        StringBuilder s = new StringBuilder();
        s.append(entry.getNewId().abbreviate(7).name());
        s.append(" ");
        s.append(this.ref == null ? "HEAD" : Repository.shortenRefName(this.ref));
        s.append("@{" + i + "}:");
        s.append(" ");
        s.append(entry.getComment());
        return s.toString();
    }
}

