/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib;

import java.io.IOException;
import java.util.HashMap;
import org.tizen.sdb.command.SysInfo;
import org.tizen.sdblib.Device;
import org.tizen.sdblib.SdbHelper;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;

public class PlatformInfo {
    private static final String KEY_MODEL_NAME = "model_name";
    private static final String KEY_PLATFORM_NAME = "platform_name";
    private static final String KEY_PLATFORM_VERSION = "platform_version";
    private static final String KEY_PROFILE_NAME = "profile_name";
    private HashMap<String, String> map = new HashMap();

    public PlatformInfo(Device device) throws TimeoutException, SdbCommandRejectedException, IOException {
        if (SmartDevelopmentBridge.getBridge() != null && SmartDevelopmentBridge.getBridge().isTims()) {
            SysInfo info = new SysInfo();
            this.map = info.getSysInfo(device.getSerialNumber());
        } else {
            byte[] reqBytes = SdbHelper.sendServiceRequest(SmartDevelopmentBridge.getBridge(), device, "sysinfo:", 512);
            byte[] tmpByte = new byte[64];
            System.arraycopy(reqBytes, 64, tmpByte, 0, 64);
            String value = SdbHelper.replyToString(tmpByte).trim();
            this.map.put(KEY_MODEL_NAME, value);
            System.arraycopy(reqBytes, 128, tmpByte, 0, 64);
            value = SdbHelper.replyToString(tmpByte).trim();
            this.map.put(KEY_PLATFORM_NAME, value);
            System.arraycopy(reqBytes, 192, tmpByte, 0, 64);
            value = SdbHelper.replyToString(tmpByte).trim();
            this.map.put(KEY_PLATFORM_VERSION, value);
            System.arraycopy(reqBytes, 256, tmpByte, 0, 64);
            value = SdbHelper.replyToString(tmpByte).trim();
            this.map.put(KEY_PROFILE_NAME, value);
        }
    }

    public String getModelName() {
        return this.map.get(KEY_MODEL_NAME);
    }

    public String getPlatformName() {
        return this.map.get(KEY_PLATFORM_NAME);
    }

    public String getPlatformVersion() {
        return this.map.get(KEY_PLATFORM_VERSION);
    }

    public String getProfileName() {
        return this.map.get(KEY_PROFILE_NAME);
    }

    public String toString() {
        String format = "model: %s, platform: %s, version: %s, profile: %s";
        return String.format(format, this.getModelName(), this.getPlatformName(), this.getPlatformVersion(), this.getProfileName());
    }
}

