/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.gom.smartlaunch.action;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.tizen.common.gom.launch.GomLaunchData;
import org.tizen.common.gom.smartlaunch.GomSmartLaunchManager;
import org.tizen.common.gom.smartlaunch.GomSmartUILauncher;
import org.tizen.common.gom.smartlaunch.action.GomSmartLaunchAction;
import org.tizen.common.gom.smartlaunch.messages.GomMessages;

public class GomSmartLaunchToolbarAction
implements IWorkbenchWindowPulldownDelegate2 {
    public Menu getMenu(Control parent) {
        Menu menu = new Menu(parent);
        this.addMenuListener(menu);
        return menu;
    }

    public void dispose() {
        GomSmartLaunchManager.getDefault().removeListener();
    }

    public void init(IWorkbenchWindow window) {
        GomSmartLaunchManager.getDefault().addListener();
    }

    public void run(IAction action) {
        List<GomLaunchData> list = GomSmartLaunchManager.getDefault().getLaunchList();
        int recentIndex = list.size() - 1;
        if (recentIndex > -1) {
            GomLaunchData data = list.get(recentIndex);
            if (GomSmartUILauncher.isExistDevice()) {
                new GomSmartLaunchAction(data).run();
            }
        } else {
            GomSmartUILauncher.openDialog();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public Menu getMenu(Menu parent) {
        Menu menu = new Menu(parent);
        this.addMenuListener(menu);
        return menu;
    }

    private void addMenuListener(Menu menu) {
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                GomSmartLaunchToolbarAction.this.fillMenu((Menu)e.widget);
            }
        });
    }

    protected void fillMenu(Menu menu) {
        List<GomLaunchData> list = GomSmartLaunchManager.getDefault().getLaunchList();
        int listCount = list.size();
        int accelerator = 1;
        int i = list.size() - 1;
        while (i >= 0) {
            GomLaunchData data = list.get(i);
            GomSmartLaunchAction action = new GomSmartLaunchAction(data);
            this.addToMenu(menu, (IAction)action, accelerator);
            ++accelerator;
            --i;
        }
        if (listCount > 0) {
            new MenuItem(menu, 2);
        }
        Action addAction = new Action(){

            public void run() {
                GomSmartUILauncher.openDialog();
            }
        };
        addAction.setText(GomMessages.SMARTLAUNCH_NEW);
        this.addToMenu(menu, (IAction)addAction, accelerator);
    }

    protected void addToMenu(Menu menu, IAction action, int accelerator) {
        StringBuffer label = new StringBuffer();
        if (accelerator >= 0 && accelerator < 10) {
            label.append('&');
            label.append(accelerator);
            label.append(' ');
        }
        label.append(action.getText());
        action.setText(label.toString());
        ActionContributionItem item = new ActionContributionItem(action);
        item.fill(menu, -1);
    }
}

