/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.explorer.action;

import java.io.File;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.connection.explorer.ConnectionExplorer;
import org.tizen.common.connection.explorer.ConnectionUIMessages;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.HostUtil;
import org.tizen.common.util.OSChecker;

public class ActionEmulatorManager
extends Action {
    private final Logger logger = LoggerFactory.getLogger(ConnectionExplorer.class);
    Shell shell;

    public ActionEmulatorManager(Shell shell) {
        this.shell = shell;
        this.setToolTipText(ConnectionUIMessages.Explorer_Tooltip_EmulatorManager);
        this.setImageDescriptor(ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/elcl18/emulator.png"));
        this.setDisabledImageDescriptor(ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/dlcl18/emulator.png"));
    }

    public void run() {
        try {
            ActionEmulatorManager.startEmulatorManager();
        }
        catch (IOException e) {
            this.logger.error("Fail to start Emulator Manager", (Throwable)e);
            MessageDialog.openError((Shell)this.shell, (String)"Fail to start Emulator Manager", (String)e.getMessage());
        }
    }

    public static void startEmulatorManager() throws IOException {
        int osType = ConnectionPlugin.getDefault().os;
        int linuxType = 0;
        String exePath = ConnectionPlugin.getDefault().getPreferenceStore().getString("emulator_manager_path");
        if (exePath.equals("") || !HostUtil.exists((String)exePath)) {
            throw new IOException(ConnectionUIMessages.Explorer_Message_EmulatorManagerError);
        }
        if (exePath.contains(" ")) {
            exePath = "\"" + exePath + "\"";
        }
        String command = OSChecker.isMAC() ? "open " + exePath + ".app" : exePath;
        if (osType == linuxType) {
            command = String.valueOf(command) + " 1>/dev/null 2>/dev/null &";
            HostUtil.execute((String)command);
        } else {
            HostUtil.batchExecute((String)command, null, (File)new File(InstallPathConfig.getEmulatorBinPath()));
        }
    }
}

