/*
 * Decompiled with CFR 0.152.
 */
package org.mihalis.opal.angles;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.mihalis.opal.utils.SWTGraphicUtil;

public class AngleSlider
extends Canvas {
    private static final int WHOLE_RADIUS = 40;
    private static final int BUTTON_RADIUS = 10;
    private static final int STEP = 5;
    private final Image backgroundImage = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/angleBackground.png"));
    private final Image buttonFocus = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/angleButtonFocus.png"));
    private final Image buttonNoFocus = new Image((Device)this.getDisplay(), ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream("images/angleButtonFocusLost.png"));
    private int selection;
    private final List<SelectionListener> selectionListeners;
    private boolean mousePressed;

    public AngleSlider(Composite parent, int style) {
        super(parent, style | 0x20000000);
        this.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                AngleSlider.this.paintControl(event);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                SWTGraphicUtil.dispose((Resource)AngleSlider.this.backgroundImage);
                SWTGraphicUtil.dispose((Resource)AngleSlider.this.buttonFocus);
                SWTGraphicUtil.dispose((Resource)AngleSlider.this.buttonNoFocus);
            }
        });
        this.addListener(3, this.createMouseListener());
        this.addListener(4, this.createMouseListener());
        this.addListener(5, this.createMouseListener());
        this.addListener(1, this.createKeyListener());
        this.selection = 0;
        this.selectionListeners = new ArrayList<SelectionListener>();
    }

    private void paintControl(Event event) {
        GC gc = event.gc;
        gc.drawImage(this.backgroundImage, 0, 0);
        float angle = (float)this.selection / 360.0f;
        angle = (float)((double)(angle * 2.0f) * Math.PI - 1.5707963267948966);
        float x = (float)(20.0 - 10.0 * Math.cos(angle));
        float y = (float)(20.0 - 10.0 * Math.sin(angle));
        if (this.isFocusControl()) {
            gc.drawImage(this.buttonFocus, (int)x - 2, (int)y - 2);
        } else {
            gc.drawImage(this.buttonNoFocus, (int)x - 2, (int)y - 2);
        }
        if (!this.isEnabled()) {
            gc.setAlpha(127);
            gc.setAntialias(1);
            gc.setBackground(this.getDisplay().getSystemColor(1));
            gc.fillOval(4, 4, 33, 33);
        }
    }

    private Listener createMouseListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (!AngleSlider.this.isEnabled()) {
                    return;
                }
                if (event.type == 3) {
                    AngleSlider.this.mousePressed = true;
                }
                if (event.type == 3 || event.type == 5 && AngleSlider.this.mousePressed) {
                    float deltaX = (float)event.x - 20.0f;
                    float deltaY = (float)event.y - 20.0f;
                    double angle = Math.atan2(deltaX, deltaY);
                    AngleSlider.this.selection = 360 - (int)(360.0 * angle / (Math.PI * 2) + 360.0) % 360;
                    AngleSlider.this.redraw();
                }
                if (event.type == 4) {
                    AngleSlider.this.mousePressed = false;
                    AngleSlider.this.fireSelectionListeners(event);
                }
            }
        };
    }

    private void fireSelectionListeners(Event event) {
        for (SelectionListener selectionListener : this.selectionListeners) {
            selectionListener.widgetSelected(new SelectionEvent(event));
        }
    }

    private Listener createKeyListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                if (!AngleSlider.this.isEnabled()) {
                    return;
                }
                if (event.type != 1) {
                    return;
                }
                if (event.keyCode == 0x1000001 || event.keyCode == 0x1000003) {
                    AngleSlider.this.setSelection(AngleSlider.this.selection + 5);
                }
                if (event.keyCode == 0x1000002 || event.keyCode == 0x1000004) {
                    AngleSlider.this.setSelection(AngleSlider.this.selection - 5);
                }
            }
        };
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.selectionListeners.add(selectionListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        return new Point(40, 40);
    }

    public int getSelection() {
        this.checkWidget();
        return this.selection;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        this.selectionListeners.remove(selectionListener);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.redraw();
    }

    public void setSelection(int selection) {
        this.checkWidget();
        if (selection < 0 || selection > 360) {
            SWT.error((int)28);
        }
        this.selection = selection;
        this.fireSelectionListeners(new Event());
        this.redraw();
    }
}

