/*
 * Decompiled with CFR 0.152.
 */
package zipeditor;

import java.text.DateFormat;
import java.text.NumberFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.program.Program;
import org.eclipse.ui.PlatformUI;
import zipeditor.Messages;
import zipeditor.PreferenceInitializer;
import zipeditor.ZipEditorPlugin;
import zipeditor.model.Node;
import zipeditor.model.ZipNode;

public class ZipLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    protected static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance();
    protected static final NumberFormat NUMBER_FORMAT = NumberFormat.getNumberInstance();
    private static Object TYPE_LABEL_KEY = new Object();
    private int[] fOrder;

    public static String getTypeLabel(Node node) {
        String label = (String)node.getProperty(TYPE_LABEL_KEY);
        if (label == null) {
            label = ZipLabelProvider.doGetTypeLabel(node);
            node.setProperty(TYPE_LABEL_KEY, label);
        }
        return label;
    }

    private static String doGetTypeLabel(Node node) {
        Program program = Program.findProgram((String)node.getType());
        IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(node.getName());
        return node.isFolder() ? Messages.getString("ZipLabelProvider.1") : (contentType != null ? contentType.getName() : (program != null ? program.getName() : (node.getType() != null && node.getType().length() > 0 ? Messages.getFormattedString("ZipLabelProvider.2", node.getType()) : Messages.getString("ZipLabelProvider.0"))));
    }

    public String getText(Object element) {
        if (element instanceof IResource) {
            return ((IResource)element).getName();
        }
        return element instanceof Node ? this.getNodeText((Node)((Object)element)) : super.getText(element);
    }

    private String getNodeText(Node node) {
        String prefix = node.isAdded() ? "*" : (node.isModified() ? ">" : new String());
        return String.valueOf(prefix) + node.getName();
    }

    public Image getImage(Object element) {
        if (element instanceof Node) {
            Node node = (Node)((Object)element);
            if (node.isFolder()) {
                return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
            }
            ImageDescriptor descriptor = PlatformUI.getWorkbench().getEditorRegistry().getImageDescriptor(node.getName());
            if (descriptor != null) {
                return ZipEditorPlugin.getImage(descriptor);
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
        return super.getImage(element);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (this.fOrder == null) {
            this.fOrder = this.initializeOrder();
        }
        if (this.fOrder.length == 0) {
            return null;
        }
        switch (this.fOrder[columnIndex]) {
            default: {
                return null;
            }
            case 1: 
        }
        return this.getImage(element);
    }

    public String getColumnText(Object element, int columnIndex) {
        if (!(element instanceof Node)) {
            return new String();
        }
        if (this.fOrder == null) {
            this.fOrder = this.initializeOrder();
        }
        if (this.fOrder.length == 0) {
            return new String();
        }
        Node node = (Node)((Object)element);
        switch (this.fOrder[columnIndex]) {
            default: {
                return this.getText(element);
            }
            case 1: {
                return this.getNodeText(node);
            }
            case 2: {
                return ZipLabelProvider.getTypeLabel(node);
            }
            case 3: {
                return ZipLabelProvider.formatDate(node.getTime());
            }
            case 4: {
                return ZipLabelProvider.formatLong(node.getSize());
            }
            case 6: {
                return ZipLabelProvider.formatLong(node instanceof ZipNode ? ((ZipNode)node).getCompressedSize() : 0L);
            }
            case 9: {
                return node.getPath();
            }
            case 8: {
                return new String(node instanceof ZipNode ? ((ZipNode)node).getExtra() : new byte[]{});
            }
            case 7: {
                return Long.toHexString(node instanceof ZipNode ? ((ZipNode)node).getCrc() : 0L);
            }
            case 5: 
        }
        return String.valueOf(ZipLabelProvider.formatLong(Math.max(Math.round(node instanceof ZipNode ? ((ZipNode)node).getRatio() : 0.0), 0L))) + "%";
    }

    private int[] initializeOrder() {
        IPreferenceStore store = ZipEditorPlugin.getDefault().getPreferenceStore();
        int[] values = (int[])PreferenceInitializer.split(store.getString("VISIBLE_COLUMNS"), ",", Integer.TYPE);
        return values;
    }

    protected static String formatDate(long time) {
        return time != -1L ? DATE_FORMAT.format(new Long(time)) : new String();
    }

    protected static String formatLong(long value) {
        return NUMBER_FORMAT.format(value);
    }
}

