/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.signer;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.IResource;
import org.tizen.common.file.LinkedResource;
import org.tizen.common.file.Resource;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.file.VirtualFileHandler;
import org.tizen.common.packager.PackageResource;
import org.tizen.common.sign.signer.ReferenceCacheParser;
import org.tizen.common.sign.signer.SignatureGenerator;
import org.tizen.common.sign.signer.TizenIncrementalSigner;
import org.tizen.common.sign.util.SignatureUtility;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.sdblib.IDevice;

public class TizenCommonSigner {
    public Collection<IResource> doSign(String dir, boolean writeToFile, String signedDir, IDevice device) throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, XMLSecurityException, ParserConfigurationException {
        StandardFileHandler sfh = new StandardFileHandler(dir);
        return this.doSign(this.getFileResources((FileHandler)sfh, ".", true), writeToFile, signedDir, device);
    }

    private Collection<IResource> getFileResources(FileHandler fh, String dir, boolean recursively) throws IOException {
        ArrayList<IResource> results = new ArrayList<IResource>();
        Collection list = fh.list(dir);
        for (String path : list) {
            path = FilenameUtil.getRelativePath2((String)fh.getCurrentWorkingDirectory(), (String)path);
            FileHandler.Type type = (FileHandler.Type)fh.get(path, FileHandler.Attribute.TYPE);
            if (FileHandler.Type.FILE.equals((Object)type)) {
                results.add((IResource)new Resource(fh, path));
                continue;
            }
            if (!FileHandler.Type.DIRECTORY.equals((Object)type) || !recursively) continue;
            results.addAll(this.getFileResources(fh, path, recursively));
        }
        return results;
    }

    /*
     * Unable to fully structure code
     */
    public Collection<IResource> doSign(Collection<IResource> resources, boolean writeToFile, String signedDir, IDevice device) throws IOException, UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException, CertificateException, XMLSecurityException, ParserConfigurationException {
        signTempPathFileHandler = new StandardFileHandler(signedDir);
        generator = new SignatureGenerator();
        generator.setDevice(device);
        profile = generator.loadProfiles();
        signer = new TizenIncrementalSigner(profile, "");
        signer.setReferenceCacheParser(new ReferenceCacheParser((FileHandler)signTempPathFileHandler));
        iss = new HashSet<InputStream>();
        try {
            for (IResource resource : resources) {
                resPath = resource.getPath();
                if (resource instanceof LinkedResource) {
                    resPath = ((LinkedResource)resource).getRealRelativePath();
                }
                if (!FileHandler.Type.FILE.equals(resource.getFileHandler().get(resPath, FileHandler.Attribute.TYPE))) continue;
                remotePath = resource.getPath();
                if (resource instanceof PackageResource) {
                    remotePath = ((PackageResource)resource).getDestination();
                }
                if ((remotePath = remotePath.replace('\\', '/')).startsWith("/")) {
                    remotePath = remotePath.substring(1);
                }
                is = resource.getContents();
                iss.add(is);
                fh = resource.getFileHandler();
                if (fh instanceof VirtualFileHandler) {
                    signer.addInputStream(remotePath, is);
                    continue;
                }
                signer.addRealPath(remotePath, FileUtil.appendPath((String)fh.getCurrentWorkingDirectory(), (String)resPath));
            }
        }
        finally {
            ** for (is : iss)
        }
lbl-1000:
        // 1 sources

        {
            IOUtil.tryClose((Object[])new Object[]{is});
            continue;
        }
lbl35:
        // 1 sources

        oss = new ArrayList<ByteArrayOutputStream>();
        signResources = new HashSet<IResource>();
        try {
            oss.add(new ByteArrayOutputStream());
            oss.add(new ByteArrayOutputStream());
            oss.add(new ByteArrayOutputStream());
            fh = signTempPathFileHandler;
            if (!writeToFile) {
                fh = new VirtualFileHandler();
                fh.setCurrentWorkingDirectory(signedDir);
            }
            signer.sign(false, oss.toArray(new OutputStream[0]));
            authorOs = (ByteArrayOutputStream)oss.get(0);
            if (authorOs != null) {
                authorResource = new Resource((FileHandler)fh, SignatureUtility.getAuthorFilename());
                authorResource.setContents(authorOs.toByteArray());
                signResources.add((IResource)authorResource);
            }
            i = 1;
            while (i < oss.size()) {
                signOs = (ByteArrayOutputStream)oss.get(i);
                if (signOs != null && signOs.size() != 0) {
                    signResource = new Resource((FileHandler)fh, SignatureUtility.getDistributorFilename(i));
                    signResource.setContents(signOs.toByteArray());
                    signResources.add((IResource)signResource);
                }
                ++i;
            }
        }
        catch (Throwable var17_23) {
            IOUtil.tryClose((Object[])new Object[]{oss});
            throw var17_23;
        }
        IOUtil.tryClose((Object[])new Object[]{oss});
        return signResources;
    }
}

