/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.model;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.Doc;
import org.tizen.common.rest.ui.views.RestViewer;
import org.tizen.common.rest.util.OutputUtil;

public class RepositoryManager {
    private static RepositoryManager instance;
    private static FilenameFilter wadlFileFilter;
    private Map<Application, File> fileMap = new LinkedHashMap<Application, File>();

    static {
        wadlFileFilter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name != null && name.endsWith(".wadl");
            }
        };
    }

    public static RepositoryManager getInstance() {
        if (instance == null) {
            instance = new RepositoryManager();
        }
        return instance;
    }

    private RepositoryManager() {
        this.loadRepository();
    }

    private void loadRepository() {
        block6: {
            try {
                File[] files;
                File folder = this.getRepositoryFolder(false);
                if (folder == null || !folder.exists()) break block6;
                File[] fileArray = files = folder.listFiles(wadlFileFilter);
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    try {
                        Application app = OutputUtil.loadWadl(file);
                        if (app != null) {
                            this.fileMap.put(app, file);
                        }
                    }
                    catch (JAXBException e) {
                        RestPlugin.log(e);
                    }
                    ++n2;
                }
            }
            catch (IOException e) {
                RestPlugin.log(e);
            }
        }
    }

    public void reloadRepository(boolean refreshRestViewer) {
        RestViewer viewer;
        this.fileMap.clear();
        this.loadRepository();
        if (refreshRestViewer && (viewer = OutputUtil.findRestViewer()) != null) {
            viewer.reloadTreeViewer();
        }
    }

    private File getRepositoryFolder(boolean createIfNotExist) throws IOException {
        IPreferenceStore prefStore = RestPlugin.getDefault().getPreferenceStore();
        String repoPath = prefStore.getString("PREF_KEY_REPO_PATH");
        File folder = new File(repoPath);
        if (createIfNotExist && !folder.exists()) {
            folder.mkdirs();
        }
        return folder;
    }

    public List<Application> getApplications() {
        return new ArrayList<Application>(this.fileMap.keySet());
    }

    public boolean updateOrAddApplications(List<Application> apps) {
        boolean result = true;
        if (apps != null) {
            Iterator<Application> itor = apps.iterator();
            while (itor.hasNext()) {
                result &= this.updateOrAddApplication(itor.next());
            }
        }
        return result;
    }

    public boolean updateOrAddApplication(Application app, String title) {
        boolean result = false;
        if (app != null) {
            File file = this.fileMap.get(app);
            if (file == null) {
                try {
                    if (title == null || title.length() == 0) {
                        title = this.extractTitle(app);
                    }
                    File folder = this.getRepositoryFolder(true);
                    title = this.createFileName(folder, title);
                    file = new File(folder, String.valueOf(title) + "." + "wadl");
                }
                catch (IOException e) {
                    RestPlugin.log(e);
                }
            }
            try {
                OutputUtil.saveWadl(file, app);
                this.fileMap.put(app, file);
                result = true;
            }
            catch (JAXBException e) {
                RestPlugin.log(e);
            }
        }
        return result;
    }

    public boolean updateOrAddApplication(Application app) {
        String title = this.extractTitle(app);
        return this.updateOrAddApplication(app, title);
    }

    private String createFileName(File folder, String filename) {
        File file = new File(folder, String.valueOf(filename) + "." + "wadl");
        if (file.exists()) {
            filename = String.valueOf(filename) + "1";
            filename = this.createFileName(folder, filename);
        }
        return filename;
    }

    public boolean removeApplication(Application app) {
        File file;
        boolean result = false;
        if (app != null && (file = this.fileMap.remove(app)) != null && file.exists()) {
            result = file.delete();
        }
        return result;
    }

    public String extractTitle(Application app) {
        List<Doc> docList;
        String result = app.getElementName();
        File file = this.fileMap.get(app);
        if (file != null) {
            result = file.getName();
        }
        if ((docList = app.getDoc()) != null && docList.size() > 0) {
            for (Doc doc : docList) {
                String title = doc.getTitle();
                if (title == null || title.length() <= 0) continue;
                result = title;
                break;
            }
        }
        return result;
    }

    public File getFile(Application app) {
        return this.fileMap.get(app);
    }
}

