/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.run;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.GzipDecompressingEntity;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.progress.IProgressService;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.RestUIMessages;
import org.tizen.common.rest.exception.AuthenticationException;
import org.tizen.common.rest.model.run.RuntimeSetting;
import org.tizen.common.rest.model.run.RuntimeSettingLocal;
import org.tizen.common.rest.model.run.TestData;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.IWadlModel;
import org.tizen.common.rest.model.schema.Method;
import org.tizen.common.rest.model.schema.Resources;
import org.tizen.common.rest.run.AbstractParamAuthProcessor;
import org.tizen.common.rest.run.IAuthProcessor;
import org.tizen.common.rest.run.ResponseDataProcessor;
import org.tizen.common.rest.run.RestApiRunner;
import org.tizen.common.rest.run.RunHistoryManager;
import org.tizen.common.rest.util.OutputUtil;
import org.tizen.common.rest.util.SSLUtilities;

public class RestTestEngine {
    private static IConfigurationElement[] authTypeElements;
    private static IAuthProcessor processor;

    static {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        authTypeElements = registry.getConfigurationElementsFor("org.tizen.common.rest.authType");
    }

    private static void checkResponse(Shell parent, List<TestData> testDataList) {
        IPreferenceStore prefStore = RestPlugin.getDefault().getPreferenceStore();
        boolean autoSave = prefStore.getBoolean("PREF_KEY_RES_SAVE_AUTO");
        boolean doNotAsk = prefStore.getBoolean("PREF_KEY_RES_SAVE_ASK");
        boolean doSave = autoSave;
        if (!doNotAsk && parent != null) {
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)parent, (String)RestUIMessages.RunPreferencePage_resSaveGroup_text, (String)RestUIMessages.RunPreferencePage_resSave_description, (String)RestUIMessages.RunPreferencePage_resSave_toggle, (boolean)doNotAsk, (IPreferenceStore)prefStore, (String)"PREF_KEY_RES_SAVE_ASK");
            int returnCode = dialog.getReturnCode();
            doNotAsk = dialog.getToggleState();
            if (doNotAsk) {
                prefStore.setValue("PREF_KEY_RES_SAVE_ASK", doNotAsk);
                prefStore.setValue("PREF_KEY_RES_SAVE_AUTO", returnCode == 0);
            }
            doSave |= returnCode == 0;
        }
        if (doSave) {
            RestTestEngine.saveResponse(testDataList);
        }
    }

    private static void saveResponse(List<TestData> testDataList) {
        ResponseDataProcessor.saveResponseData(testDataList);
    }

    public static synchronized void run(Shell parent, IStructuredSelection selection, boolean checkResponse) {
        List list = selection.toList();
        ArrayList<Method> mList = new ArrayList<Method>();
        int i = 0;
        while (i < list.size()) {
            Object obj = list.get(i);
            if (obj instanceof Application) {
                RestTestEngine.run(checkResponse, parent, (Application)obj);
            } else if (obj instanceof IWadlModel) {
                IWadlModel model = (IWadlModel)obj;
                if (model instanceof Method) {
                    mList.add((Method)model);
                } else {
                    List<IWadlModel> children = model.getChildren();
                    RestTestEngine.gatherMethods(mList, children);
                }
            }
            ++i;
        }
        if (mList.size() > 0) {
            try {
                RestTestEngine.run(checkResponse, parent, mList);
            }
            catch (AuthenticationException e) {
                MessageDialog.openError((Shell)parent, (String)"Authentication Error", (String)e.getMessage());
                return;
            }
        }
        if (selection instanceof ITreeSelection) {
            RunHistoryManager rManager = RunHistoryManager.getInstance();
            rManager.putRunHistory((ITreeSelection)selection);
        }
    }

    public static synchronized void run(Shell parent, IStructuredSelection selection) {
        RestTestEngine.run(parent, selection, true);
    }

    private static synchronized void run(boolean checkResponse, Shell parent, Application app) {
        ArrayList<Method> mList = new ArrayList<Method>();
        List<Resources> resourcesList = app.getResources();
        int i = 0;
        while (i < resourcesList.size()) {
            Resources ress = resourcesList.get(i);
            List<IWadlModel> resList = ress.getChildren();
            RestTestEngine.gatherMethods(mList, resList);
            ++i;
        }
        RestTestEngine.run(checkResponse, parent, mList);
    }

    private static synchronized void run(final boolean checkResponse, final Shell parent, final List<Method> apis) {
        IWorkbench workbench = DebugUIPlugin.getDefault().getWorkbench();
        IProgressService progressService = workbench.getProgressService();
        Rectangle parentBounds = parent.getBounds();
        final MessageConsoleStream out = OutputUtil.newConsoleStream();
        final DefaultHttpClient client = RestTestEngine.createHttpClient();
        RestTestEngine.setTimeout((HttpClient)client);
        RestTestEngine.checkProxySettings(client);
        RestTestEngine.setResponseInterceptor((AbstractHttpClient)client);
        String appId = apis.get(0).getRoot().getElementId();
        IPreferenceStore store = RestPlugin.getDefault().getPreferenceStore();
        boolean useAuth = store.getBoolean(RestTestEngine.getKeyByAppId("PREF_KEY_USE_AUTH", appId));
        if (useAuth) {
            String activeAuthType = store.getString(RestTestEngine.getKeyByAppId("PREF_KEY_ACTIVE_AUTH_TYPE", appId));
            if (activeAuthType != null && activeAuthType.length() > 0) {
                if (authTypeElements == null) {
                    IExtensionRegistry registry = Platform.getExtensionRegistry();
                    authTypeElements = registry.getConfigurationElementsFor("org.tizen.common.rest.authType");
                }
                IConfigurationElement[] iConfigurationElementArray = authTypeElements;
                int n = authTypeElements.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    String id = element.getAttribute("id");
                    if (activeAuthType.equals(id)) {
                        try {
                            processor = (IAuthProcessor)element.createExecutableExtension("authProcessingClass");
                            break;
                        }
                        catch (CoreException e) {
                            RestPlugin.log(e);
                        }
                    }
                    ++n2;
                }
            }
            if (processor != null && !processor.authentication(parentBounds, out, client, appId)) {
                processor = null;
                throw new AuthenticationException("Authentication failed!");
            }
        }
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                Display display;
                int count = apis.size();
                monitor.beginTask(RestUIMessages.apiRunStart, count);
                RuntimeSetting runtimeSetting = new RuntimeSetting();
                RuntimeSettingLocal.set(runtimeSetting);
                final ArrayList<TestData> testDataList = new ArrayList<TestData>();
                if (!monitor.isCanceled()) {
                    int i = 0;
                    while (i < count) {
                        TestData data;
                        ModalContext.checkCanceled((IProgressMonitor)monitor);
                        Method method = (Method)apis.get(i);
                        RestApiRunner runner = new RestApiRunner(monitor, out, (HttpClient)client, method);
                        if (processor != null && processor instanceof AbstractParamAuthProcessor) {
                            AbstractParamAuthProcessor paramProcessor = (AbstractParamAuthProcessor)processor;
                            runner.setAuthProcessor(paramProcessor);
                        }
                        if (200 == (data = runner.run()).getResponseModel().getResponseCode()) {
                            testDataList.add(data);
                        }
                        monitor.worked(1);
                        ++i;
                    }
                }
                RuntimeSettingLocal.remove();
                if (client != null && client.getConnectionManager() != null) {
                    client.getConnectionManager().shutdown();
                }
                try {
                    out.close();
                }
                catch (IOException e) {
                    RestPlugin.log(e);
                }
                monitor.done();
                if (checkResponse && (display = DebugUIPlugin.getStandardDisplay()) != null && !display.isDisposed()) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            RestTestEngine.checkResponse(parent, testDataList);
                        }
                    });
                }
            }
        };
        try {
            try {
                progressService.busyCursorWhile(runnable);
            }
            catch (InvocationTargetException e) {
                RestPlugin.log(e);
                processor = null;
            }
            catch (InterruptedException e) {
                RestPlugin.log(e);
                processor = null;
            }
        }
        finally {
            processor = null;
        }
    }

    private static String getKeyByAppId(String originalKey, String appId) {
        String result = originalKey;
        if (appId != null && appId.length() > 0) {
            result = String.valueOf(result) + "." + appId;
        }
        return result;
    }

    private static DefaultHttpClient createHttpClient() {
        SSLUtilities.trustAllHostnames();
        SSLUtilities.trustAllHttpsCertificates();
        return new DefaultHttpClient();
    }

    private static void setResponseInterceptor(AbstractHttpClient client) {
        client.addResponseInterceptor(new HttpResponseInterceptor(){

            public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
                Header ceheader;
                HttpEntity entity = response.getEntity();
                if (entity != null && (ceheader = entity.getContentEncoding()) != null) {
                    HeaderElement[] codecs = ceheader.getElements();
                    int i = 0;
                    while (i < codecs.length) {
                        if (codecs[i].getName().equalsIgnoreCase("gzip")) {
                            response.setEntity((HttpEntity)new GzipDecompressingEntity(response.getEntity()));
                            return;
                        }
                        ++i;
                    }
                }
            }
        });
    }

    private static void setTimeout(HttpClient client) {
        HttpConnectionParams.setConnectionTimeout((HttpParams)client.getParams(), (int)10000);
        HttpConnectionParams.setSoTimeout((HttpParams)client.getParams(), (int)10000);
    }

    private static void checkProxySettings(DefaultHttpClient client) {
        IPreferenceStore prefStore = RestPlugin.getDefault().getPreferenceStore();
        boolean useProxy = prefStore.getBoolean("PREF_KEY_USE_PROXY");
        if (useProxy) {
            String host = prefStore.getString("PREF_KEY_PROXY_HOST");
            int port = prefStore.getInt("PREF_KEY_PROXY_PORT");
            try {
                HttpHost proxy = new HttpHost(host, port);
                client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
                boolean useProxyAuth = prefStore.getBoolean("PREF_KEY_USE_PROXY_AUTH");
                if (useProxyAuth) {
                    String user = prefStore.getString("PREF_KEY_PROXY_USER");
                    String password = prefStore.getString("PREF_KEY_PROXY_PASSWORD");
                    CredentialsProvider cp = client.getCredentialsProvider();
                    cp.setCredentials(new AuthScope(host, port), (Credentials)new UsernamePasswordCredentials(user, password));
                }
            }
            catch (IllegalArgumentException e) {
                RestPlugin.log(e);
            }
        }
    }

    private static void gatherMethods(List<Method> buffer, List<IWadlModel> list) {
        int i = 0;
        while (i < list.size()) {
            IWadlModel model = list.get(i);
            if (model instanceof Method) {
                Method m = (Method)model;
                buffer.add(m);
            } else {
                List<IWadlModel> children = model.getChildren();
                RestTestEngine.gatherMethods(buffer, children);
            }
            ++i;
        }
    }
}

