/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.preferences;

import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.rest.ui.preferences.AbstractPreferencePage;
import org.tizen.common.rest.ui.preferences.TableEditorValidator;

public abstract class AbstractTablePreferencePage
extends AbstractPreferencePage {
    private Table table;
    private TableEditor editor;
    private Button addBtn;
    private Button delBtn;
    private Button upBtn;
    private Button downBtn;
    private boolean modified;
    private Listener buttonGroupListener = new Listener(){

        public void handleEvent(Event e) {
            if (e.widget == AbstractTablePreferencePage.this.addBtn) {
                boolean success = AbstractTablePreferencePage.this.openAddPopup(AbstractTablePreferencePage.this.table);
                if (success) {
                    AbstractTablePreferencePage.this.setModified(true);
                }
            } else if (e.widget == AbstractTablePreferencePage.this.delBtn) {
                AbstractTablePreferencePage.this.deleteSelectedTableItems();
                AbstractTablePreferencePage.this.setModified(true);
            } else if (e.widget == AbstractTablePreferencePage.this.upBtn) {
                AbstractTablePreferencePage.this.upDownTableItems(true);
                AbstractTablePreferencePage.this.setModified(true);
            } else if (e.widget == AbstractTablePreferencePage.this.downBtn) {
                AbstractTablePreferencePage.this.upDownTableItems(false);
                AbstractTablePreferencePage.this.setModified(true);
            }
        }
    };

    public AbstractTablePreferencePage(String description) {
        super(description);
    }

    protected Table getTable() {
        return this.table;
    }

    protected TableEditor getTableEditor() {
        return this.editor;
    }

    protected abstract boolean openAddPopup(Table var1);

    protected void upDownTableItems(boolean up) {
        int[] indices = this.table.getSelectionIndices();
        int[] newIndices = new int[indices.length];
        int i = 0;
        while (i < indices.length) {
            int newIndex;
            int index = indices[i];
            TableItem item = this.table.getItem(index);
            String key = item.getText(0);
            String val = item.getText(1);
            this.table.remove(index);
            newIndices[i] = newIndex = index - (up ? 1 : -1);
            item = new TableItem(this.table, 0, newIndex);
            item.setText(new String[]{key, val});
            ++i;
        }
        this.table.setSelection(newIndices);
        this.updateButtonsEnableState();
    }

    protected void deleteSelectedTableItems() {
        int[] indices = this.table.getSelectionIndices();
        this.table.remove(indices);
    }

    @Override
    protected void loadData() {
    }

    @Override
    protected Composite createContentArea(Composite parent) {
        Composite composite = this.createComposite(parent, 1);
        this.table = this.createTable(composite);
        this.createButtonGroup(composite);
        this.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractTablePreferencePage.this.updateButtonsEnableState();
            }
        });
        this.updateButtonsEnableState();
        return composite;
    }

    protected void initInPlaceEditor(final TableItem item, final int index, final TableEditorValidator validator) {
        Control oldEditor = this.editor.getEditor();
        if (oldEditor != null) {
            oldEditor.dispose();
        }
        final Text text = new Text((Composite)this.table, 0);
        Listener textListener = new Listener(){
            boolean validating = false;

            public void handleEvent(Event e) {
                if (this.validating) {
                    return;
                }
                boolean valid = true;
                switch (e.type) {
                    case 16: {
                        if (validator != null) {
                            valid = this.validate(validator, item, text);
                        }
                        if (valid) {
                            item.setText(index, text.getText());
                        }
                        text.dispose();
                        AbstractTablePreferencePage.this.setModified(true);
                        break;
                    }
                    case 31: {
                        switch (e.detail) {
                            case 4: {
                                if (validator != null) {
                                    valid = this.validate(validator, item, text);
                                }
                                if (valid) {
                                    item.setText(index, text.getText());
                                }
                                text.dispose();
                                AbstractTablePreferencePage.this.setModified(true);
                            }
                            case 2: {
                                if (!text.isDisposed()) {
                                    text.dispose();
                                }
                                e.doit = false;
                            }
                        }
                    }
                }
            }

            private boolean validate(TableEditorValidator validator2, TableItem item2, Text text2) {
                this.validating = true;
                boolean valid = validator2.validate(item2, text2);
                this.validating = false;
                return valid;
            }
        };
        text.addListener(16, textListener);
        text.addListener(31, textListener);
        this.editor.setEditor((Control)text, item, index);
        text.setText(item.getText(index));
        text.selectAll();
        text.setFocus();
    }

    protected void initInPlaceEditor(TableItem item, int index) {
        this.initInPlaceEditor(item, index, null);
    }

    protected void updateButtonsEnableState() {
        int[] indices = this.table.getSelectionIndices();
        boolean calDel = false;
        boolean canUp = false;
        boolean canDown = false;
        if (indices.length > 0) {
            calDel = true;
            if (indices[0] != 0) {
                canUp = true;
            }
            if (indices[indices.length - 1] != this.table.getItemCount() - 1) {
                canDown = true;
            }
        }
        this.delBtn.setEnabled(calDel);
        this.upBtn.setEnabled(canUp);
        this.downBtn.setEnabled(canDown);
    }

    protected void createButtonGroup(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData data = new GridData(0x1000000, 0x1000000, false, false, 1, 1);
        composite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(5, false);
        composite.setLayout((Layout)layout);
        this.addBtn = this.createButton(composite, "Add", 80, 20);
        this.addBtn.addListener(13, this.buttonGroupListener);
        GridData gd = new GridData();
        gd.widthHint = 80;
        this.addBtn.setLayoutData((Object)gd);
        this.delBtn = this.createButton(composite, "Delete", 80, 20);
        this.delBtn.addListener(13, this.buttonGroupListener);
        gd = new GridData();
        gd.widthHint = 80;
        this.delBtn.setLayoutData((Object)gd);
        Label blank = this.createLabel(composite, "");
        gd = new GridData();
        gd.widthHint = 30;
        blank.setLayoutData((Object)gd);
        this.upBtn = this.createButton(composite, "Up", 80, 20);
        this.upBtn.addListener(13, this.buttonGroupListener);
        gd = new GridData();
        gd.widthHint = 80;
        this.upBtn.setLayoutData((Object)gd);
        this.downBtn = this.createButton(composite, "Down", 80, 20);
        this.downBtn.addListener(13, this.buttonGroupListener);
        gd = new GridData();
        gd.widthHint = 80;
        this.downBtn.setLayoutData((Object)gd);
    }

    protected Table createTable(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        composite.setLayoutData((Object)gd);
        composite.setLayout((Layout)new FillLayout());
        this.table = new Table(composite, 68354);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.createTableColumns(this.table);
        this.editor = new TableEditor(this.table);
        this.editor.horizontalAlignment = 16384;
        this.editor.grabHorizontal = true;
        this.editor.minimumWidth = 50;
        this.loadTableData();
        return this.table;
    }

    protected abstract void createTableColumns(Table var1);

    protected abstract String getTableItemDataKey();

    protected void loadTableData() {
        if (this.table == null) {
            return;
        }
        this.table.removeAll();
        String str = this.getValue(this.getTableItemDataKey());
        if (str != null && str.length() > 0) {
            String[] strs;
            String[] stringArray = strs = str.split("\\|");
            int n = strs.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                String[] cols = line.split("=");
                if (cols != null && cols.length >= 1) {
                    TableItem item = new TableItem(this.table, 0);
                    item.setText(cols);
                }
                ++n2;
            }
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        this.loadTableData();
        this.setModified(false);
    }

    @Override
    public void performApply() {
        String str = this.makePreferenceValue();
        this.setValue(this.getTableItemDataKey(), str);
        this.setModified(false);
    }

    protected String makePreferenceValue() {
        return AbstractTablePreferencePage.makePreferenceValue(this.table);
    }

    public static String makePreferenceValue(Table table) {
        TableItem[] items = table.getItems();
        StringBuilder builder = new StringBuilder();
        TableItem[] tableItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            String key = item.getText(0);
            String value = item.getText(1);
            builder.append(String.valueOf(key) + "=" + value + "|");
            ++n2;
        }
        return builder.toString();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }
}

