/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.preferences;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.tizen.common.rest.ui.preferences.AuthPreferencePage;
import org.tizen.common.rest.ui.preferences.IRestAuthPreference;

class AuthPrefSection {
    private AuthPreferencePage authPreferencePage;
    private String id;
    private String title;
    private String description;
    private IRestAuthPreference authTypePref;
    private Button radio;
    private Label descLabel;
    private Group typeGroup;

    public static AuthPrefSection createSection(AuthPreferencePage authPreferencePage, Composite parent, String id, String title, String description, IRestAuthPreference authTypePref) {
        AuthPrefSection section = new AuthPrefSection(authPreferencePage, id, title, description, authTypePref);
        section.createContents(parent);
        return section;
    }

    private AuthPrefSection() {
    }

    private AuthPrefSection(AuthPreferencePage authPreferencePage, String id, String title, String description, IRestAuthPreference authTypePref) {
        this.authPreferencePage = authPreferencePage;
        this.id = id;
        this.title = title;
        this.description = description;
        this.authTypePref = authTypePref;
    }

    private void createContents(Composite parent) {
        this.radio = this.createRadioButton(parent, this.title, this.id);
        this.radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AuthPrefSection.this.updateUIState(true);
            }
        });
        this.descLabel = this.authPreferencePage.createLabel(parent, this.description);
        this.typeGroup = new Group(parent, 0);
        GridData gd = new GridData(768);
        this.typeGroup.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        this.typeGroup.setLayout((Layout)layout);
        this.authTypePref.createContentArea((Composite)this.typeGroup);
    }

    private Button createRadioButton(Composite parent, String title, String id) {
        Button radio = this.authPreferencePage.createButton(parent, 16, title, 0, 0);
        radio.setData("PREF_KEY_ACTIVE_AUTH_TYPE", (Object)id);
        return radio;
    }

    public String getId() {
        return this.id;
    }

    public IRestAuthPreference getAuthTypePref() {
        return this.authTypePref;
    }

    public boolean getSelection() {
        return this.radio.getSelection();
    }

    public void setSelection(boolean selected) {
        this.radio.setSelection(selected);
        this.setChildEnabled(selected);
    }

    private void setChildEnabled(boolean enabled) {
        this.descLabel.setEnabled(enabled);
        this.typeGroup.setEnabled(enabled);
        this.authTypePref.setEnabled(enabled);
    }

    public void setEnabled(boolean enabled) {
        this.radio.setEnabled(enabled);
        this.setChildEnabled(enabled);
    }

    public void setSelection(String activeAuthType) {
        boolean selected = activeAuthType.equals(this.id);
        this.setSelection(selected);
    }

    public void updateUIState(boolean radioEnabled) {
        this.radio.setEnabled(radioEnabled);
        boolean selected = this.radio.getSelection();
        this.setChildEnabled(selected);
    }
}

