/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.views;

import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.tizen.common.rest.model.RepositoryManager;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.Doc;
import org.tizen.common.rest.model.schema.Method;
import org.tizen.common.rest.model.schema.Resource;
import org.tizen.common.rest.model.schema.Resources;
import org.tizen.common.rest.ui.RestImageRegistry;
import org.tizen.common.rest.util.ModelUtil;
import org.tizen.common.util.ImageUtil;

public class RestViewerLabelProvider
extends LabelProvider {
    public String getText(Object obj) {
        return RestViewerLabelProvider.getDisplayName(obj);
    }

    public Image getImage(Object obj) {
        return RestViewerLabelProvider.getImageIcon(obj);
    }

    public static String getDisplayName(Object obj) {
        if (obj instanceof Application) {
            Application app = (Application)obj;
            RepositoryManager rManager = RepositoryManager.getInstance();
            return rManager.extractTitle(app);
        }
        if (obj instanceof Resources) {
            Resources rs = (Resources)obj;
            String alias = rs.getTitle();
            if (alias == null) {
                return rs.getBase();
            }
            return alias;
        }
        if (obj instanceof Resource) {
            return ((Resource)obj).getPath();
        }
        if (obj instanceof Method) {
            Method method = ModelUtil.findReferences((Method)obj);
            String id = method.getId();
            if (id != null) {
                return id;
            }
            List<Doc> docList = method.getDoc();
            if (docList != null && docList.size() > 0) {
                for (Doc doc : docList) {
                    String title = doc.getTitle();
                    if (title == null || title.length() <= 0) continue;
                    return title;
                }
            } else {
                return "";
            }
        }
        return obj.toString();
    }

    public static Image getImageIcon(Object obj) {
        if (obj instanceof Application) {
            return ImageUtil.getImage((ImageDescriptor)RestImageRegistry.IMG_DESC_MODEL_APPLICATION);
        }
        if (obj instanceof Resources) {
            return ImageUtil.getImage((ImageDescriptor)RestImageRegistry.IMG_DESC_MODEL_RESOURCES);
        }
        if (obj instanceof Resource) {
            return ImageUtil.getImage((ImageDescriptor)RestImageRegistry.IMG_DESC_MODEL_RESOURCE);
        }
        if (obj instanceof Method) {
            String name = ModelUtil.findReferences((Method)obj).getName();
            if ("GET".equals(name)) {
                return ImageUtil.getImage((ImageDescriptor)RestImageRegistry.IMG_DESC_MODEL_METHOD_GET);
            }
            if ("POST".equals(name)) {
                return ImageUtil.getImage((ImageDescriptor)RestImageRegistry.IMG_DESC_MODEL_METHOD_POST);
            }
            if ("PUT".equals(name)) {
                return ImageUtil.getImage((ImageDescriptor)RestImageRegistry.IMG_DESC_MODEL_METHOD_PUT);
            }
            if ("DELETE".equals(name)) {
                return ImageUtil.getImage((ImageDescriptor)RestImageRegistry.IMG_DESC_MODEL_METHOD_DELETE);
            }
            return ImageUtil.getImage((ImageDescriptor)RestImageRegistry.IMG_DESC_MODEL_METHOD);
        }
        return null;
    }
}

