/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.wizard;

import java.lang.reflect.InvocationTargetException;
import keycertificategenerator.TizenKeyCertificateGenerator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.sign.ui.dialog.CertificateCreationWizardDialog;
import org.tizen.common.sign.ui.dialog.NewProfileNotificationDialog;
import org.tizen.common.sign.ui.wizard.AuthorCertCreationPage;
import org.tizen.common.sign.ui.wizard.AuthorCertImportPage;
import org.tizen.common.sign.ui.wizard.AuthorCertSelectionPage;
import org.tizen.common.sign.ui.wizard.CertificateBaseWizardPage;
import org.tizen.common.sign.ui.wizard.DistributorCertImportPage;
import org.tizen.common.sign.ui.wizard.DistributorCertSelectionPage;
import org.tizen.common.sign.ui.wizard.Messages;
import org.tizen.common.sign.ui.wizard.ProfileCreationPage;
import org.tizen.common.sign.util.SigningPathUtil;
import org.tizen.common.sign.util.SigningProfileUtil;
import org.tizen.common.util.DialogUtil;

public class CertificateCreationWizard
extends Wizard
implements IPageChangedListener {
    private static final String PROFILE_CREATION_PAGE = "p1";
    private static final String AUTHOR_CERT_SELECTION_PAGE = "p2";
    private static final String AUTHOR_CERT_CREATION_PAGE = "p3";
    private static final String AUTHOR_CERT_IMPORT_PAGE = "p4";
    private static final String DIST_CERT_SELECTION_PAGE = "p5";
    private static final String DIST_CERT_IMPORT_PAGE = "p6";
    private static final int CERTIFICATE_PROFILE_NAVI_IDX = 0;
    private static final int AUTHOR_CERTIFICATE_NAVI_IDX = 1;
    private static final int DISTRIBUTOR_CERTIFICATE_NAVI_IDX = 2;
    private boolean bCanFinish = false;
    private boolean isFirstProfile = false;
    private ProfileCreationPage profileCreationPage;
    private AuthorCertSelectionPage authCertSelectionPage;
    private AuthorCertCreationPage authCertCreationPage;
    private AuthorCertImportPage authCertImportPage;
    private DistributorCertSelectionPage distCertSelectionPage;
    private DistributorCertImportPage distCertImportPage;
    private CertificateCreationWizardDialog wizardDialog;
    protected SigningProfileContainer container = SigningProfileUtil.getProfileContainerFromFile();
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public void addPages() {
        this.profileCreationPage = new ProfileCreationPage(PROFILE_CREATION_PAGE);
        this.profileCreationPage.setNavigationIndex(0);
        this.authCertSelectionPage = new AuthorCertSelectionPage(AUTHOR_CERT_SELECTION_PAGE);
        this.authCertSelectionPage.setNavigationIndex(1);
        this.addPage((IWizardPage)this.profileCreationPage);
        this.addPage((IWizardPage)this.authCertSelectionPage);
        this.wizardDialog = (CertificateCreationWizardDialog)this.getContainer();
        this.wizardDialog.addPageChangedListener(this);
        this.wizardDialog.setNavigationString(new String[]{Messages.CERT_PROFILE_CREATE_STEP1, Messages.CERT_PROFILE_CREATE_STEP2, Messages.CERT_PROFILE_CREATE_STEP3});
    }

    public String getWindowTitle() {
        return Messages.CERT_WIZARD_TITLE;
    }

    public boolean canFinish() {
        return this.bCanFinish;
    }

    public void setCanFinish(boolean b) {
        this.bCanFinish = b;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.authCertSelectionPage) {
            if (this.authCertSelectionPage.isSelectedNewCreation()) {
                if (this.authCertCreationPage == null) {
                    this.authCertCreationPage = new AuthorCertCreationPage(AUTHOR_CERT_CREATION_PAGE);
                    this.authCertCreationPage.setNavigationIndex(1);
                    this.addPage((IWizardPage)this.authCertCreationPage);
                }
                return this.authCertCreationPage;
            }
            if (this.authCertImportPage == null) {
                this.authCertImportPage = new AuthorCertImportPage(AUTHOR_CERT_IMPORT_PAGE);
                this.authCertImportPage.setNavigationIndex(1);
                this.addPage((IWizardPage)this.authCertImportPage);
            }
            return this.authCertImportPage;
        }
        if (page == this.authCertCreationPage || page == this.authCertImportPage) {
            if (this.distCertSelectionPage == null) {
                this.distCertSelectionPage = new DistributorCertSelectionPage(DIST_CERT_SELECTION_PAGE);
                this.distCertSelectionPage.setNavigationIndex(2);
                this.addPage((IWizardPage)this.distCertSelectionPage);
            }
            return this.distCertSelectionPage;
        }
        if (page == this.distCertSelectionPage && this.distCertSelectionPage.isSelectedAnother()) {
            if (this.distCertImportPage == null) {
                this.distCertImportPage = new DistributorCertImportPage(DIST_CERT_IMPORT_PAGE);
                this.distCertImportPage.setNavigationIndex(2);
                this.addPage((IWizardPage)this.distCertImportPage);
            }
            return this.distCertImportPage;
        }
        return super.getNextPage(page);
    }

    public boolean performCancel() {
        int result = DialogUtil.openQuestionDialog((String)Messages.CERT_WIZARD_TITLE, (String)Messages.CERT_WIZARD_CANCEL);
        return result == 64;
    }

    public boolean performFinish() {
        String distPassword;
        String distKeyPath;
        String email;
        String department;
        String organization;
        String city;
        String state;
        String country;
        String password;
        String userName;
        String keyFilename;
        String authorPassword;
        String authorKeyPath;
        final boolean isNewAuthor = this.authCertSelectionPage.isSelectedNewCreation();
        final boolean isImportDist = this.distCertSelectionPage.isSelectedAnother();
        final String profileName = this.profileCreationPage.getProfileName();
        if (!isNewAuthor) {
            authorKeyPath = this.authCertImportPage.getCertPath();
            authorPassword = this.authCertImportPage.getPassword();
            keyFilename = null;
            userName = null;
            password = null;
            country = null;
            state = null;
            city = null;
            organization = null;
            department = null;
            email = null;
        } else {
            authorKeyPath = null;
            authorPassword = null;
            keyFilename = this.authCertCreationPage.getKeyfilename();
            userName = this.authCertCreationPage.getUsername();
            password = this.authCertCreationPage.getPassword();
            country = this.authCertCreationPage.getCountry();
            state = this.authCertCreationPage.getState();
            city = this.authCertCreationPage.getCity();
            organization = this.authCertCreationPage.getOrganization();
            department = this.authCertCreationPage.getDepartment();
            email = this.authCertCreationPage.getEmail();
        }
        if (isImportDist) {
            distKeyPath = this.distCertImportPage.getCertPath();
            distPassword = this.distCertImportPage.getPassword();
        } else {
            distKeyPath = null;
            distPassword = null;
        }
        try {
            new ProgressMonitorDialog(this.getShell()).run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.PROGRESS_CREATE_CERT_PROFILE, 4);
                    SigningProfile profile = new SigningProfile(profileName);
                    profile.createEmptyProfileItem(0);
                    monitor.worked(1);
                    if (isNewAuthor) {
                        monitor.setTaskName(Messages.PROGRESS_CREATE_AUTHOR_CERT);
                        String pkcsKeyStorePath = SigningPathUtil.getAuthorKeyStorePath((String)keyFilename);
                        try {
                            TizenKeyCertificateGenerator.KeyCertGeneratorFromIde((String)country, (String)state, (String)city, (String)userName, (String)organization, (String)department, (String)email, (String)SigningPathUtil.getCertificateGeneratorPath(), (String)password, (String)userName, (String)pkcsKeyStorePath);
                        }
                        catch (Exception e) {
                            throw new InvocationTargetException(e);
                        }
                        SigningProfileItem item = profile.getAuthorProfileItem();
                        item.setKeyLocation(pkcsKeyStorePath);
                        item.setPassword(password.toCharArray());
                    } else {
                        monitor.setTaskName(Messages.PROGRESS_IMPORT_AUTHOR_CERT);
                        SigningProfileItem item = profile.getAuthorProfileItem();
                        item.setKeyLocation(authorKeyPath);
                        item.setPassword(authorPassword.toCharArray());
                    }
                    monitor.worked(1);
                    if (isImportDist) {
                        monitor.setTaskName(Messages.PROGRESS_IMPORT_DIST_CERT);
                        profile.createProfileItem(1, distKeyPath, distPassword, "", "");
                    } else if (CertificateCreationWizard.this.distCertSelectionPage.isPartnerSelected()) {
                        profile.createProfileItemForPartnerDeveloper();
                    } else {
                        profile.createProfileItemForDeveloper();
                    }
                    profile.createEmptyProfileItem(2);
                    monitor.worked(1);
                    CertificateCreationWizard.this.isFirstProfile = CertificateCreationWizard.this.container.getActiveProfile() == null && CertificateCreationWizard.this.container.getProfiles().isEmpty();
                    CertificateCreationWizard.this.container.addProfile(profile);
                    SigningProfileUtil.writeProfilesToFile((SigningProfileContainer)CertificateCreationWizard.this.container);
                    CertificateCreationWizard.this.logger.trace("New certificate profile is saved");
                    monitor.worked(1);
                    monitor.done();
                }
            });
        }
        catch (Exception e) {
            this.logger.error("Failed to create a new certificate profile", (Throwable)e);
            return false;
        }
        NewProfileNotificationDialog createdDlg = new NewProfileNotificationDialog(this.getShell(), this.isFirstProfile);
        createdDlg.open();
        if (createdDlg.isSetActive()) {
            SigningProfileUtil.setActiveProfileName((String)profileName);
        }
        return true;
    }

    public boolean needsProgressMonitor() {
        return true;
    }

    public void pageChanged(PageChangedEvent event) {
        CertificateBaseWizardPage page = (CertificateBaseWizardPage)((Object)event.getSelectedPage());
        this.wizardDialog.setNavigatorCurrentPage(page.getNavigationIndex());
        this.wizardDialog.redrawNavigator();
        if (page == this.distCertImportPage) {
            this.distCertImportPage.validate();
        } else if (page == this.distCertSelectionPage) {
            this.distCertSelectionPage.validate();
        }
    }
}

