/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.model.schema;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.CollapsedStringAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.namespace.QName;
import org.tizen.common.rest.model.schema.AbstractWadlModel;
import org.tizen.common.rest.model.schema.Doc;
import org.tizen.common.rest.model.schema.IRestUiModel;
import org.tizen.common.rest.model.schema.IWadlModel;
import org.tizen.common.rest.model.schema.Method;
import org.tizen.common.rest.model.schema.Param;
import org.tizen.common.rest.model.schema.Resources;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="", propOrder={"doc", "param", "methodOrResource", "any"})
@XmlRootElement(name="resource")
public class Resource
extends AbstractWadlModel
implements IRestUiModel {
    protected List<Doc> doc;
    protected List<Param> param;
    @XmlElements(value={@XmlElement(name="method", type=Method.class), @XmlElement(name="resource", type=Resource.class)})
    protected List<IWadlModel> methodOrResource;
    @XmlAnyElement(lax=true)
    protected List<Object> any;
    @XmlAttribute(name="id")
    @XmlJavaTypeAdapter(value=CollapsedStringAdapter.class)
    @XmlID
    @XmlSchemaType(name="ID")
    protected String id;
    @XmlAttribute(name="type")
    protected List<String> type;
    @XmlAttribute(name="queryType")
    protected String queryType;
    @XmlAttribute(name="path")
    protected String path;
    @XmlAnyAttribute
    private Map<QName, String> otherAttributes = new HashMap<QName, String>();

    public Resource() {
    }

    public Resource(String path) {
        this.path = path;
    }

    @Override
    public List<IWadlModel> getChildren() {
        ArrayList<IWadlModel> list = new ArrayList<IWadlModel>();
        list.addAll(this.getDoc());
        list.addAll(this.getParam());
        list.addAll(this.getMethodOrResource());
        return list;
    }

    public List<Doc> getDoc() {
        if (this.doc == null) {
            this.doc = new ArrayList<Doc>();
        }
        return this.doc;
    }

    public List<Param> getParam() {
        if (this.param == null) {
            this.param = new ArrayList<Param>();
        }
        return this.param;
    }

    public List<IWadlModel> getMethodOrResource() {
        if (this.methodOrResource == null) {
            this.methodOrResource = new ArrayList<IWadlModel>();
        }
        return this.methodOrResource;
    }

    public List<Object> getAny() {
        if (this.any == null) {
            this.any = new ArrayList<Object>();
        }
        return this.any;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String value) {
        this.id = value;
    }

    public List<String> getType() {
        if (this.type == null) {
            this.type = new ArrayList<String>();
        }
        return this.type;
    }

    public String getQueryType() {
        if (this.queryType == null) {
            return "application/x-www-form-urlencoded";
        }
        return this.queryType;
    }

    public void setQueryType(String value) {
        this.queryType = value;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String value) {
        this.path = value;
    }

    public Map<QName, String> getOtherAttributes() {
        return this.otherAttributes;
    }

    @Override
    public void addChild(IRestUiModel model) {
        if (model instanceof Resource) {
            Resource resource = (Resource)model;
            this.getMethodOrResource().add(resource);
            resource.setParent(this);
        } else if (model instanceof Method) {
            Method method = (Method)model;
            this.getMethodOrResource().add(method);
            method.setParent(this);
        } else if (model instanceof Param) {
            Param param = (Param)model;
            this.getParam().add(param);
            param.setParent(this);
        }
    }

    @Override
    public void removeChild(IRestUiModel model) {
        if (model instanceof Resource) {
            Resource resource = (Resource)model;
            this.getMethodOrResource().remove(resource);
            resource.setParent(null);
        } else if (model instanceof Method) {
            Method method = (Method)model;
            this.getMethodOrResource().remove(method);
            method.setParent(null);
        } else if (model instanceof Param) {
            Param param = (Param)model;
            this.getParam().remove(param);
            param.setParent(null);
        }
    }

    @Override
    public boolean isVaildChild(IRestUiModel model) {
        return model instanceof Resource || model instanceof Method;
    }

    @Override
    public IRestUiModel update(IRestUiModel updateModel) {
        if (updateModel instanceof Resource) {
            Resource r = (Resource)updateModel;
            this.setPath(r.getPath());
            this.setQueryType(r.getQueryType());
            return this;
        }
        return null;
    }

    @Override
    public void delete() {
        IWadlModel p = this.getParent();
        if (p != null) {
            if (p instanceof Resources) {
                ((Resources)p).removeChild(this);
            } else {
                ((Resource)p).removeChild(this);
            }
        }
    }

    @Override
    public String getElementId() {
        return this.getPath();
    }

    @Override
    public String getDisplayName() {
        return "Path";
    }

    @Override
    public void insertBefore(IRestUiModel model, IRestUiModel target) {
        this.insert(model, target, true);
    }

    @Override
    public void insertAfter(IRestUiModel model, IRestUiModel target) {
        this.insert(model, target, false);
    }

    private void insert(IRestUiModel model, IRestUiModel target, boolean isBefore) {
        int index;
        if ((model instanceof Method || model instanceof Resource) && (target instanceof Method || target instanceof Resource) && (index = this.getMethodOrResource().indexOf(target)) > -1) {
            this.getMethodOrResource().add(isBefore ? index : index + 1, model);
            ((AbstractWadlModel)((Object)model)).setParent(this);
        }
    }
}

