/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.ui.dialogs;

import javax.xml.namespace.QName;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxViewerCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.widgets.Composite;
import org.tizen.common.rest.constants.IRestUIConstants;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.IRestUiModel;
import org.tizen.common.rest.model.schema.IWadlModel;
import org.tizen.common.rest.model.schema.Method;
import org.tizen.common.rest.model.schema.Param;
import org.tizen.common.rest.model.schema.ParamStyle;
import org.tizen.common.rest.model.schema.Resource;
import org.tizen.common.rest.ui.dialogs.RestDialog;
import org.tizen.common.rest.ui.dialogs.RestParamLableProvider;
import org.tizen.common.rest.ui.dialogs.UserVariableCellEditor;
import org.tizen.common.util.StringUtil;

public class RestParamEditing
extends EditingSupport {
    private TableViewer viewer;
    private Param.PROPERTY dataProperty = null;
    private RestDialog dialog;
    private TextCellEditor textEditor = null;
    private UserVariableCellEditor uvEditor = null;
    private ComboBoxViewerCellEditor comboEditor = null;
    private CheckboxCellEditor checkEditor = null;

    public RestParamEditing(RestDialog dialog, TableViewer viewer, Param.PROPERTY dataProperty) {
        super((ColumnViewer)viewer);
        this.dialog = dialog;
        this.viewer = viewer;
        this.dataProperty = dataProperty;
        this.createEditor();
        switch (dataProperty) {
            case NAME: 
            case VALUE: {
                break;
            }
            case STYLE: {
                this.comboEditor.setInput((Object)IRestUIConstants.DEFAULT_PARAM_STYLE_ITEMS);
                break;
            }
            case TYPE: {
                this.comboEditor.setInput((Object)IRestUIConstants.DEFAULT_PARAM_TYPE_ITEMS);
                break;
            }
        }
    }

    private void createEditor() {
        switch (this.dataProperty) {
            case NAME: {
                this.textEditor = new TextCellEditor((Composite)this.viewer.getTable());
                break;
            }
            case VALUE: {
                this.uvEditor = new UserVariableCellEditor((Composite)this.viewer.getTable());
                break;
            }
            case STYLE: 
            case TYPE: {
                this.comboEditor = new ComboBoxViewerCellEditor((Composite)this.viewer.getTable(), 8);
                this.comboEditor.setLabelProvider((IBaseLabelProvider)new RestParamLableProvider());
                this.comboEditor.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
                break;
            }
            case REQUIRED: {
                this.checkEditor = new CheckboxCellEditor((Composite)this.viewer.getTable(), 40);
            }
        }
    }

    protected CellEditor getCellEditor(Object element) {
        switch (this.dataProperty) {
            case NAME: {
                return this.textEditor;
            }
            case VALUE: {
                return this.uvEditor;
            }
            case STYLE: 
            case TYPE: {
                return this.comboEditor;
            }
            case REQUIRED: {
                return this.checkEditor;
            }
        }
        return null;
    }

    protected boolean canEdit(Object element) {
        IRestUiModel[] parents = this.dialog.setModelsOnDialog();
        boolean isFind = false;
        IRestUiModel[] iRestUiModelArray = parents;
        int n = parents.length;
        int n2 = 0;
        while (n2 < n) {
            IRestUiModel parent = iRestUiModelArray[n2];
            if (RestParamEditing.isParent((Param)element, parent)) {
                isFind = true;
                break;
            }
            ++n2;
        }
        if (isFind) {
            switch (this.dataProperty) {
                case PARENT: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected Object getValue(Object element) {
        Param data = this.castRestParamData(element);
        if (data != null) {
            switch (this.dataProperty) {
                case NAME: {
                    return data.getName();
                }
                case VALUE: {
                    return data.getDefault();
                }
                case STYLE: {
                    ParamStyle style = data.getStyle();
                    if (style != null) {
                        return style.value();
                    }
                }
                case TYPE: {
                    return data.getType().getLocalPart();
                }
                case REQUIRED: {
                    return data.isRequired();
                }
            }
        }
        return data;
    }

    protected void setValue(Object element, Object value) {
        Param param = this.castRestParamData(element);
        if (param != null) {
            switch (this.dataProperty) {
                case NAME: {
                    param.setName((String)value);
                    break;
                }
                case VALUE: {
                    param.setDefault((String)value);
                    break;
                }
                case STYLE: {
                    if (value == null) break;
                    param.setStyle(ParamStyle.valueOf(((String)value).toUpperCase()));
                    break;
                }
                case TYPE: {
                    param.setType(QName.valueOf((String)value));
                    break;
                }
                case REQUIRED: {
                    param.setRequired((Boolean)value);
                }
            }
            this.viewer.update(element, null);
        }
    }

    private Param castRestParamData(Object element) {
        Param param = null;
        if (element instanceof Param) {
            param = (Param)element;
        }
        return param;
    }

    public static boolean isParent(Param param, IRestUiModel model) {
        boolean isFind = false;
        IWadlModel parent = param.getParent();
        String parentStr = null;
        if (parent instanceof Application) {
            parentStr = ((Application)parent).getTitle();
        } else if (parent instanceof Resource) {
            parentStr = ((Resource)parent).getPath();
        } else if (parent instanceof Method) {
            parentStr = ((Method)parent).getId();
        }
        String targetStr = null;
        if (model instanceof Application) {
            targetStr = ((Application)model).getTitle();
        } else if (model instanceof Resource) {
            targetStr = ((Resource)model).getPath();
        } else if (model instanceof Method) {
            targetStr = ((Method)model).getId();
        }
        if (!StringUtil.isEmpty((CharSequence)parentStr) && !StringUtil.isEmpty((CharSequence)targetStr) && parentStr.equals(targetStr)) {
            isFind = true;
        }
        return isFind;
    }
}

