/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.rest.RestPlugin;
import org.tizen.common.rest.exception.ResourcesNotFoundException;
import org.tizen.common.rest.model.run.Cookie;
import org.tizen.common.rest.model.schema.Application;
import org.tizen.common.rest.model.schema.IRestUiModel;
import org.tizen.common.rest.model.schema.Resource;
import org.tizen.common.rest.model.schema.Resources;
import org.tizen.common.rest.util.VariableNameProcessor;

public class StringUtil {
    private static final Pattern placeHolderPattern = Pattern.compile("\\$\\{(.*?)\\}");
    private static final Pattern pathVariablesPattern = Pattern.compile("\\{(.*?)\\}");
    private static ThreadLocal<SimpleDateFormat> format = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        }
    };

    public static String getConvertedStringFromActiveProfile(String original) {
        Map<String, NameValuePair> map = StringUtil.getActiveProfileVariablesMap();
        return StringUtil.getConvertedString(original, map);
    }

    public static String getConvertedString(String original, Map<String, NameValuePair> variableMap) {
        String result = original;
        if (original != null && original.length() > 0) {
            StringBuffer sb = new StringBuffer();
            Matcher m = placeHolderPattern.matcher(original);
            while (m.find()) {
                String toReplace = m.group(1);
                NameValuePair obj = variableMap.get(toReplace);
                if (obj == null) continue;
                String toInsert = obj.getValue();
                if (toInsert.contains("$")) {
                    toInsert = toInsert.replace("$", "\\$");
                }
                m.appendReplacement(sb, toInsert);
            }
            m.appendTail(sb);
            result = sb.toString();
        }
        return result;
    }

    public static String getConvertedPath(String originalPath, Map<String, NameValuePair> pathMap) {
        if (originalPath == null) {
            originalPath = "";
        }
        String result = originalPath;
        if (originalPath != null && originalPath.length() > 0) {
            StringBuffer sb = new StringBuffer();
            Matcher m = pathVariablesPattern.matcher(originalPath);
            while (m.find()) {
                String toReplace = m.group(1);
                NameValuePair obj = pathMap.get(toReplace);
                if (obj == null) continue;
                NameValuePair toInsert = obj;
                String value = toInsert.getValue();
                if (value == null) {
                    value = "";
                }
                if (value.contains("$")) {
                    value = value.replace("$", "\\$");
                }
                m.appendReplacement(sb, value);
            }
            m.appendTail(sb);
            result = sb.toString();
        }
        return result;
    }

    public static String getRegexString(String srcString, String regex, int group, int matchNo, String defaultValue) {
        String result = null;
        if (srcString != null && srcString.length() > 0) {
            try {
                Pattern p = Pattern.compile(regex);
                Matcher m = p.matcher(srcString);
                int count = 1;
                while (m.find()) {
                    String toExtract;
                    if (count != matchNo) continue;
                    result = toExtract = m.group(group);
                    break;
                }
            }
            catch (Exception e) {
                RestPlugin.log(e);
            }
        }
        if (result == null) {
            result = defaultValue;
        }
        return result;
    }

    public static List<String> getRegexStrings(String srcString, String regex, int group) {
        ArrayList<String> result = new ArrayList<String>();
        if (srcString != null && srcString.length() > 0) {
            try {
                Pattern p = Pattern.compile(regex);
                Matcher m = p.matcher(srcString);
                while (m.find()) {
                    String toExtract = m.group(group);
                    result.add(toExtract);
                }
            }
            catch (Exception e) {
                RestPlugin.log(e);
            }
        }
        return result;
    }

    public static List<String> extractPathVariable(String srcString) {
        ArrayList<String> result = new ArrayList<String>();
        if (srcString != null && srcString.length() > 0) {
            try {
                Matcher m = pathVariablesPattern.matcher(srcString);
                while (m.find()) {
                    String toExtract = m.group(1);
                    result.add(toExtract);
                }
            }
            catch (Exception e) {
                RestPlugin.log(e);
            }
        }
        return result;
    }

    public static void main(String[] args) {
        String str = "/api/v1/{{storeId}}/users/{{userId}}";
        List<String> list = StringUtil.extractPathVariable(str);
        System.out.println(list);
    }

    public static void supportContentAssist(Text text) {
        new VariableNameProcessor();
    }

    public static String formatDate(Date date) {
        return format.get().format(date);
    }

    public static String getCookieData(Cookie c) {
        return String.valueOf(c.getName()) + "=" + c.getValue() + "; Domain=" + c.getDomain() + "; Path=" + c.getPath();
    }

    public static String getLineSeparator() {
        String lf = System.getProperty("line.separator");
        if (lf == null || lf.length() == 0) {
            lf = "\n";
        }
        return lf;
    }

    public static String getActiveProfileVariables() {
        String key = StringUtil.getActiveProfileVariablesKey();
        IPreferenceStore prefStore = RestPlugin.getDefault().getPreferenceStore();
        return prefStore.getString("PREF_KEY_USER_VARIABLES." + key);
    }

    public static Map<String, NameValuePair> getActiveProfileVariablesMap() {
        String prop = StringUtil.getActiveProfileVariables();
        if (prop != null && prop.length() > 0) {
            String[] args = prop.split("\\|");
            LinkedHashMap<String, NameValuePair> map = new LinkedHashMap<String, NameValuePair>();
            String[] stringArray = args;
            int n = args.length;
            int n2 = 0;
            while (n2 < n) {
                String arg = stringArray[n2];
                String[] line = new String[]{"", ""};
                line = arg.split("=");
                BasicNameValuePair nameValuePair = new BasicNameValuePair(line[0], line[1]);
                map.put(nameValuePair.getName(), (NameValuePair)nameValuePair);
                ++n2;
            }
            return map;
        }
        return Collections.emptyMap();
    }

    public static String getActiveProfileVariablesKey() {
        IPreferenceStore prefStore = RestPlugin.getDefault().getPreferenceStore();
        return prefStore.getString("PREF_KEY_USER_VARIABLES_SELECTED_PROFILE");
    }

    public static String getFullPathString(IRestUiModel model) throws ResourcesNotFoundException {
        String result = null;
        TreePath fullPath = model.getFullPath();
        Object rootObj = fullPath.getFirstSegment();
        if (!(rootObj instanceof Application)) {
            throw new ResourcesNotFoundException(model);
        }
        Resources base = null;
        StringBuffer pathBuf = new StringBuffer();
        int i = 1;
        while (i < fullPath.getSegmentCount()) {
            String[] subPaths;
            Resource res;
            String path;
            Object obj = fullPath.getSegment(i);
            if (obj instanceof Resources) {
                base = (Resources)obj;
            } else if (obj instanceof Resource && (path = (res = (Resource)obj).getPath()) != null && path.length() > 0 && (subPaths = path.split("/")).length > 0) {
                String[] stringArray = subPaths;
                int n = subPaths.length;
                int n2 = 0;
                while (n2 < n) {
                    String p = stringArray[n2];
                    if (p.length() > 0) {
                        pathBuf.append("/" + p);
                    }
                    ++n2;
                }
            }
            ++i;
        }
        if (base == null) {
            throw new ResourcesNotFoundException(model);
        }
        String baseUrl = base.getBase();
        if (baseUrl.endsWith("/") && pathBuf.length() > 0) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        String path = pathBuf.toString();
        result = String.valueOf(baseUrl) + path;
        return result;
    }
}

