/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.rest.util;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.HashSet;
import nu.xom.Attribute;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Elements;
import nu.xom.Node;
import nu.xom.ParsingException;
import nu.xom.Serializer;
import org.tizen.common.rest.util.TypeInferenceUtilEx;
import org.wiztools.commons.Charsets;
import org.wiztools.commons.StringUtil;
import org.wiztools.xsdgen.ParseException;

public final class XsdGenEx {
    private static final String XSD_NS_URI = "http://www.w3.org/2001/XMLSchema";
    private final String XSD_PREFIX;
    private Document doc = null;

    public XsdGenEx(String prefix) {
        this.XSD_PREFIX = prefix;
    }

    public XsdGenEx() {
        this.XSD_PREFIX = "xsd";
    }

    private void processAttributes(Element inElement, Element outElement) {
        int i = 0;
        while (i < inElement.getAttributeCount()) {
            Attribute attr = inElement.getAttribute(i);
            String name = attr.getLocalName();
            String value = attr.getValue();
            Element attrElement = new Element(String.valueOf(this.XSD_PREFIX) + ":attribute", XSD_NS_URI);
            attrElement.addAttribute(new Attribute("name", name));
            attrElement.addAttribute(new Attribute("type", String.valueOf(this.XSD_PREFIX) + TypeInferenceUtilEx.getTypeOfContent(value)));
            attrElement.addAttribute(new Attribute("use", "required"));
            outElement.appendChild((Node)attrElement);
            ++i;
        }
    }

    private void recurseGen(Element parent, Element parentOutElement) {
        Element complexType = new Element(String.valueOf(this.XSD_PREFIX) + ":complexType", XSD_NS_URI);
        Element sequence = new Element(String.valueOf(this.XSD_PREFIX) + ":sequence", XSD_NS_URI);
        complexType.appendChild((Node)sequence);
        this.processAttributes(parent, complexType);
        parentOutElement.appendChild((Node)complexType);
        Elements childs = parent.getChildElements();
        HashSet<String> elementNamesProcessed = new HashSet<String>();
        int i = 0;
        while (i < childs.size()) {
            Element e = childs.get(i);
            String localName = e.getLocalName();
            String nsURI = e.getNamespaceURI();
            String nsName = e.getQualifiedName();
            if (!elementNamesProcessed.contains(nsName)) {
                if (e.getChildElements().size() > 0) {
                    Element element = new Element(String.valueOf(this.XSD_PREFIX) + ":element", XSD_NS_URI);
                    element.addAttribute(new Attribute("name", localName));
                    if (parent.getChildElements(localName, nsURI).size() > 1) {
                        element.addAttribute(new Attribute("maxOccurs", "unbounded"));
                    } else {
                        element.addAttribute(new Attribute("minOccurs", "0"));
                        element.addAttribute(new Attribute("maxOccurs", "1"));
                    }
                    this.recurseGen(e, element);
                    sequence.appendChild((Node)element);
                } else {
                    String cnt = e.getValue();
                    String eValue = cnt == null ? null : cnt.trim();
                    String type = String.valueOf(this.XSD_PREFIX) + TypeInferenceUtilEx.getTypeOfContent(eValue);
                    Element element = new Element(String.valueOf(this.XSD_PREFIX) + ":element", XSD_NS_URI);
                    element.addAttribute(new Attribute("name", localName));
                    if (parent.getChildElements(localName, nsURI).size() > 1) {
                        element.addAttribute(new Attribute("maxOccurs", "unbounded"));
                    } else {
                        element.addAttribute(new Attribute("minOccurs", "0"));
                        element.addAttribute(new Attribute("maxOccurs", "1"));
                    }
                    int attrCount = e.getAttributeCount();
                    if (attrCount > 0) {
                        Element complexTypeCurrent = new Element(String.valueOf(this.XSD_PREFIX) + ":complexType", XSD_NS_URI);
                        Element simpleContent = new Element(String.valueOf(this.XSD_PREFIX) + ":simpleContent", XSD_NS_URI);
                        Element extension = new Element(String.valueOf(this.XSD_PREFIX) + ":extension", XSD_NS_URI);
                        extension.addAttribute(new Attribute("base", type));
                        this.processAttributes(e, extension);
                        simpleContent.appendChild((Node)extension);
                        complexTypeCurrent.appendChild((Node)simpleContent);
                        element.appendChild((Node)complexTypeCurrent);
                    } else {
                        element.addAttribute(new Attribute("type", type));
                    }
                    sequence.appendChild((Node)element);
                }
            }
            elementNamesProcessed.add(nsName);
            ++i;
        }
    }

    private Document getDocument(String srcXmlString) throws ParsingException, IOException {
        Builder parser = new Builder();
        Document srcXmlDoc = parser.build(srcXmlString, null);
        return this.getDocument(srcXmlDoc);
    }

    private Document getDocument(File file) throws ParsingException, IOException {
        Builder parser = new Builder();
        Document srcXmlDoc = parser.build(file);
        return this.getDocument(srcXmlDoc);
    }

    private Document getDocument(Document srcXmlDoc) throws ParsingException, IOException {
        Element rootElement = srcXmlDoc.getRootElement();
        Element outRoot = new Element(String.valueOf(this.XSD_PREFIX) + ":schema", XSD_NS_URI);
        Document outDoc = new Document(outRoot);
        String nsPrefix = rootElement.getNamespacePrefix();
        if (!StringUtil.isStrEmpty((String)nsPrefix)) {
            outRoot.addAttribute(new Attribute("targetNamespace", rootElement.getNamespaceURI()));
            outRoot.addAttribute(new Attribute("elementFormDefault", "qualified"));
        }
        int i = 0;
        while (i < rootElement.getNamespaceDeclarationCount()) {
            String nsPrefix2 = rootElement.getNamespacePrefix(i);
            String nsURI = rootElement.getNamespaceURI(nsPrefix2);
            outRoot.addNamespaceDeclaration(nsPrefix2, nsURI);
            ++i;
        }
        Element rootElementXsd = new Element(String.valueOf(this.XSD_PREFIX) + ":element", XSD_NS_URI);
        rootElementXsd.addAttribute(new Attribute("name", rootElement.getLocalName()));
        outRoot.appendChild((Node)rootElementXsd);
        this.recurseGen(rootElement, rootElementXsd);
        this.processAttributes(rootElement, rootElementXsd);
        return outDoc;
    }

    public XsdGenEx parse(File file) throws IOException, ParseException {
        try {
            this.doc = this.getDocument(file);
            return this;
        }
        catch (ParsingException ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public XsdGenEx parse(String xmlString) throws IOException, ParseException {
        try {
            this.doc = this.getDocument(xmlString);
            return this;
        }
        catch (ParsingException ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public void write(OutputStream os) throws IOException {
        if (this.doc == null) {
            throw new IllegalStateException("Call parse() before calling this method!");
        }
        this.write(os, Charsets.UTF_8);
    }

    public void write(OutputStream os, Charset charset) throws IOException {
        if (this.doc == null) {
            throw new IllegalStateException("Call parse() before calling this method!");
        }
        Serializer serializer = new Serializer(os, charset.name());
        serializer.setIndent(2);
        serializer.write(this.doc);
    }

    public String toString() {
        String xml = this.doc.toXML();
        return xml == null ? "[Not yet initialized!]" : xml;
    }
}

