/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdb.command;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import org.json.simple.parser.ParseException;
import org.tizen.sdb.Buffer;
import org.tizen.sdb.Channel;
import org.tizen.sdb.CommandResponse;
import org.tizen.sdb.command.Command;
import org.tizen.sdb.command.DebugWebReceiver;
import org.tizen.sdb.command.receiver.OutputReceiver;

public class Launch
extends Command {
    private boolean debugNative = false;
    protected static String SUCCESS = "successfully";

    public Launch() {
        this("launch");
    }

    protected Launch(String command) {
        super(command);
    }

    public void setParameter(String mode, String appID, int port, int pid, String testMode, String userArgs) throws IOException {
        if (mode == null || mode.isEmpty()) {
            System.out.println("launch mode is empty");
            throw new IOException();
        }
        if (appID == null || appID.isEmpty()) {
            System.out.println("launch application id is empty");
            throw new IOException();
        }
        this.addParameter("-p");
        this.addParameter("p");
        this.addParameter("-e");
        this.addParameter("e");
        this.addParameter("-m");
        this.addParameter(mode);
        this.addParameter("-a");
        this.addParameter(appID);
        if (port > 0) {
            this.addParameter("-P");
            this.addParameter(Integer.toString(port));
        }
        if (pid > 0) {
            this.addParameter("-attach");
            this.addParameter(Integer.toString(pid));
        }
        if (testMode != null && !testMode.isEmpty()) {
            this.addParameter("-t");
            this.addParameter(testMode);
        }
        if (userArgs != null && !userArgs.isEmpty()) {
            this.addParameter(userArgs);
        }
    }

    public void runApplication(String appID, String deviceSerial, OutputReceiver receiver) throws IOException {
        this.setParameter("run", appID, 0, 0, null, null);
        this.execute(deviceSerial, receiver);
    }

    public void runUnitTestApplication(String appID, String userArgs, String deviceSerial, OutputReceiver receiver) throws IOException {
        this.setParameter("run", appID, 0, 0, "gtest", userArgs);
        this.execute(deviceSerial, receiver);
    }

    public void debugNativeApplication(String appID, int debugPort, int pid, String deviceSerial, OutputReceiver receiver) throws IOException {
        this.setParameter("debug", appID, debugPort, pid, null, null);
        if (pid <= 0) {
            this.debugNative = true;
        }
        this.execute(deviceSerial, receiver);
    }

    public int debugWebApplication(String appID, String deviceSerial) throws IOException {
        this.setParameter("debug", appID, 0, 0, null, null);
        DebugWebReceiver receiver = new DebugWebReceiver();
        this.execute(deviceSerial, (OutputReceiver)receiver);
        return receiver.getPort();
    }

    @Override
    protected void receiveResponse(Channel channel, OutputReceiver receiver) throws IOException {
        Buffer buffer;
        block7: {
            if (!this.debugNative || receiver != null) {
                super.receiveResponse(channel, receiver);
                return;
            }
            while (true) {
                if ((buffer = channel.read()) == null) {
                    throw new IOException();
                }
                if (buffer.getType() != Buffer.BufferType.DATA) break block7;
                int length = buffer.getLength();
                if (length <= 0) continue;
                ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                byteOut.write(buffer.get(), 0, length);
                String data = null;
                try {
                    data = new String(byteOut.toByteArray(), Command.UTF_DECODING);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new IOException();
                }
                if (data != null && data.contains(SUCCESS)) break;
            }
            this.setResponse(new CommandResponse(0, "", ""));
            return;
        }
        CommandResponse response = null;
        try {
            response = new CommandResponse(new String(buffer.get(), Command.UTF_DECODING));
        }
        catch (ParseException e) {
            e.printStackTrace();
            response = new CommandResponse();
        }
        this.setResponse(response);
    }
}

