/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.template;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.FactoryWithArgument;
import org.tizen.common.file.Filter;
import org.tizen.common.file.SimpleFileFilter;
import org.tizen.common.file.filter.WildCardFilterFactory;
import org.tizen.common.util.ReflectionUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.verrari.IModelProvider;
import org.tizen.common.verrari.ITemplateEngine;
import org.tizen.common.verrari.Storage;
import org.tizen.common.verrari.Template;
import org.tizen.common.verrari.TemplateException;
import org.tizen.common.verrari.exception.InvalidMapperException;
import org.tizen.common.verrari.template.Mapper;
import org.tizen.common.verrari.template.TemplateConstants;

public abstract class CommonTemplate
implements Template {
    protected static final ThreadLocal<CommonTemplate> context = new ThreadLocal();
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected ResourceBundle defaultBundle;
    protected final HashMap<Locale, ResourceBundle> bundles = new HashMap();
    protected final HashMap<String, String> attrs = new HashMap();
    protected FactoryWithArgument<Filter, String> filterFactory = new WildCardFilterFactory();
    protected ITemplateEngine engine = null;
    protected Mapper mapper = null;
    protected HashSet<String> templateNames = new HashSet();
    protected HashSet<String> copyNames = new HashSet();

    @Override
    public abstract void template(IModelProvider var1, Storage var2) throws TemplateException;

    public static CommonTemplate getCurrentTemplate() {
        return context.get();
    }

    @Override
    public Collection<String> getAttributeKeys() {
        return this.attrs.keySet();
    }

    @Override
    public String getAttribute(String key) {
        return this.attrs.get(key);
    }

    protected void loadAttribute(InputStream in) throws IOException {
        Manifest manifest = new Manifest(in);
        Attributes attributes = manifest.getMainAttributes();
        for (Object key : attributes.keySet()) {
            Attributes.Name name = (Attributes.Name)key;
            String keyStr = name.toString();
            this.attrs.put(keyStr, attributes.getValue(name));
        }
        this.logger.info("Attribute :{}", this.attrs);
    }

    public void setFilterFactory(FactoryWithArgument<Filter, String> factory) {
        this.filterFactory = factory;
        this.logger.debug("Configured filter factory :{}", factory);
    }

    protected Filter createFilter(String[] includes, String[] excludes) {
        int n;
        int n2;
        String[] stringArray;
        SimpleFileFilter filter = new SimpleFileFilter();
        if (includes != null) {
            stringArray = includes;
            n2 = includes.length;
            n = 0;
            while (n < n2) {
                String include = stringArray[n];
                filter.addIncludes(new Filter[]{(Filter)this.filterFactory.create((Object)include)});
                ++n;
            }
        }
        if (excludes != null) {
            stringArray = excludes;
            n2 = excludes.length;
            n = 0;
            while (n < n2) {
                String exclude = stringArray[n];
                filter.addExcludes(new Filter[]{(Filter)this.filterFactory.create((Object)exclude)});
                ++n;
            }
        }
        return filter;
    }

    public String getMessage(String key) {
        this.logger.trace("Key :{}", (Object)key);
        Locale locale = Locale.getDefault();
        ResourceBundle bundle = this.bundles.get(locale);
        if (bundle != null) {
            return this.getMessage(bundle, key);
        }
        bundle = this.bundles.get(locale = new Locale(locale.getLanguage(), ""));
        if (bundle != null) {
            return this.getMessage(bundle, key);
        }
        if (this.defaultBundle != null) {
            return this.getMessage(this.defaultBundle, key);
        }
        return null;
    }

    protected String getMessage(ResourceBundle bundle, String key) {
        if (!bundle.containsKey(key)) {
            this.logger.info("No message for {}", (Object)key);
            return null;
        }
        String ret = bundle.getString(key);
        this.logger.info("Message for {} :{}", (Object)key, (Object)ret);
        return ret;
    }

    protected Mapper getMapper(String mapperName, String mappings) throws InvalidMapperException {
        String safeMapperName = StringUtil.nvl((String[])new String[]{mapperName, TemplateConstants.DV_MAPPER});
        Mapper mapper = (Mapper)ReflectionUtil.tryNewInstance((String)safeMapperName);
        if (mapper == null) {
            throw new InvalidMapperException("'" + safeMapperName + "' is invalide. check your class or config");
        }
        HashMap<String, String> mappingMap = new HashMap<String, String>();
        if (mappings != null) {
            BufferedReader reader = new BufferedReader(new StringReader(mappings));
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    String[] args = line.split("/");
                    mappingMap.put(args[0], args[1]);
                }
            }
            catch (IOException iOException) {
                throw new IllegalStateException("Unreachable block");
            }
        }
        mapper.setMappings(mappingMap);
        return mapper;
    }
}

